/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.binding.list;

import com.jgoodies.binding.beans.Model;
import com.jgoodies.binding.list.ArrayListModel;
import com.jgoodies.binding.value.ValueHolder;
import com.jgoodies.binding.value.ValueModel;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.ListModel;
import javax.swing.event.EventListenerList;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class ListModelHolder
extends Model
implements ListModel {
    public static final String PROPERTYNAME_LIST_MODEL = "listModel";
    public static final String PROPERTYNAME_LIST_MODEL_HOLDER = "listModelHolder";
    private ValueModel listModelHolder;
    protected ListModel listModel;
    private final PropertyChangeListener listModelChangeHandler;
    protected final ListDataListener listDataChangeHandler;
    private final EventListenerList listenerList = new EventListenerList();

    public ListModelHolder() {
        this(new ArrayListModel());
    }

    public ListModelHolder(ListModel listModel) {
        this(new ValueHolder(listModel, true));
    }

    public ListModelHolder(ValueModel listModelHolder) {
        this.listModelHolder = listModelHolder;
        if (listModelHolder == null) {
            throw new NullPointerException("The ListModel holder must not be null.");
        }
        this.checkListModelHolderIdentityCheck(listModelHolder);
        this.listModelChangeHandler = new ListModelChangeHandler();
        this.listDataChangeHandler = this.createListDataChangeHandler();
        listModelHolder.addValueChangeListener(this.listModelChangeHandler);
        this.listModel = (ListModel)listModelHolder.getValue();
        if (this.listModel != null) {
            this.listModel.addListDataListener(this.listDataChangeHandler);
        }
    }

    public final ListModel getListModel() {
        return (ListModel)this.getListModelHolder().getValue();
    }

    public final void setListModel(ListModel newListModel) {
        this.getListModelHolder().setValue(newListModel);
    }

    public final ValueModel getListModelHolder() {
        return this.listModelHolder;
    }

    public final void setListModelHolder(ValueModel newListModelHolder) {
        if (newListModelHolder == null) {
            throw new NullPointerException("The new ListModel holder must not be null.");
        }
        this.checkListModelHolderIdentityCheck(newListModelHolder);
        ValueModel oldListModelHolder = this.getListModelHolder();
        if (this.equals(oldListModelHolder, newListModelHolder)) {
            return;
        }
        ListModel oldListModel = this.listModel;
        ListModel newListModel = (ListModel)newListModelHolder.getValue();
        oldListModelHolder.removeValueChangeListener(this.listModelChangeHandler);
        this.listModelHolder = newListModelHolder;
        newListModelHolder.addValueChangeListener(this.listModelChangeHandler);
        this.updateListModel(oldListModel, newListModel);
        this.firePropertyChange(PROPERTYNAME_LIST_MODEL_HOLDER, oldListModelHolder, newListModelHolder);
    }

    public final boolean isEmpty() {
        return this.getSize() == 0;
    }

    public final int getSize() {
        return this.getSize(this.getListModel());
    }

    public final Object getElementAt(int index) {
        return this.getListModel().getElementAt(index);
    }

    public final void addListDataListener(ListDataListener l) {
        this.listenerList.add(ListDataListener.class, l);
    }

    public final void removeListDataListener(ListDataListener l) {
        this.listenerList.remove(ListDataListener.class, l);
    }

    public final ListDataListener[] getListDataListeners() {
        return (ListDataListener[])this.listenerList.getListeners(ListDataListener.class);
    }

    public final void fireContentsChanged(int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ListModelHolder.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 0, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).contentsChanged(e);
        }
    }

    public final void fireIntervalAdded(int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ListModelHolder.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 1, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalAdded(e);
        }
    }

    public final void fireIntervalRemoved(int index0, int index1) {
        Object[] listeners = this.listenerList.getListenerList();
        ListDataEvent e = null;
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ListDataListener == null ? ListModelHolder.class$("javax.swing.event.ListDataListener") : class$javax$swing$event$ListDataListener)) continue;
            if (e == null) {
                e = new ListDataEvent(this, 2, index0, index1);
            }
            ((ListDataListener)listeners[i + 1]).intervalRemoved(e);
        }
    }

    protected ListDataListener createListDataChangeHandler() {
        return new ListDataChangeHandler();
    }

    protected void updateListModel(ListModel oldListModel, ListModel newListModel) {
        if (oldListModel != null) {
            oldListModel.removeListDataListener(this.listDataChangeHandler);
        }
        if (newListModel != null) {
            newListModel.addListDataListener(this.listDataChangeHandler);
        }
        this.listModel = newListModel;
        this.firePropertyChange(PROPERTYNAME_LIST_MODEL, oldListModel, newListModel);
        this.fireListChanged(this.getSize(oldListModel) - 1, this.getSize(newListModel) - 1);
    }

    protected final void fireListChanged(int oldLastIndex, int newLastIndex) {
        if (oldLastIndex == newLastIndex) {
            if (newLastIndex == -1) {
                return;
            }
            this.fireContentsChanged(0, newLastIndex);
        } else {
            if (oldLastIndex >= 0) {
                this.fireIntervalRemoved(0, oldLastIndex);
            }
            if (newLastIndex >= 0) {
                this.fireIntervalAdded(0, newLastIndex);
            }
        }
    }

    protected final int getSize(ListModel aListOrNull) {
        return aListOrNull == null ? 0 : aListOrNull.getSize();
    }

    private void checkListModelHolderIdentityCheck(ValueModel aListModelHolder) throws IllegalArgumentException {
        if (!(aListModelHolder instanceof ValueHolder)) {
            return;
        }
        ValueHolder valueHolder = (ValueHolder)aListModelHolder;
        if (!valueHolder.isIdentityCheckEnabled()) {
            throw new IllegalArgumentException("The ListModel holder must have the identity check enabled.");
        }
    }

    private final class ListDataChangeHandler
    implements ListDataListener {
        private ListDataChangeHandler() {
        }

        public void intervalAdded(ListDataEvent evt) {
            ListModelHolder.this.fireIntervalAdded(evt.getIndex0(), evt.getIndex1());
        }

        public void intervalRemoved(ListDataEvent evt) {
            ListModelHolder.this.fireIntervalRemoved(evt.getIndex0(), evt.getIndex1());
        }

        public void contentsChanged(ListDataEvent evt) {
            ListModelHolder.this.fireContentsChanged(evt.getIndex0(), evt.getIndex1());
        }
    }

    private final class ListModelChangeHandler
    implements PropertyChangeListener {
        private ListModelChangeHandler() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            ListModel oldListModel = ListModelHolder.this.listModel;
            ListModel newListModel = (ListModel)evt.getNewValue();
            ListModelHolder.this.updateListModel(oldListModel, newListModel);
        }
    }
}

