package edu.ucla.ccb.graphshifts.data;

import java.io.Serializable;

public class Point3D implements Serializable
{
	public double x,y,z;

	public Point3D()
	{
	}
	
	public Point3D(double x, double y, double z)
	{
		this.x = x;
		this.y = y;
		this.z = z;
	}
	
	public void copyContents(Point3D P)
	{
		x = P.x;
		y = P.y;
		z = P.z;
	}
	
	/** Return Euclidean distance... */
	public double distance(Point3D Q)
	{
		return Math.sqrt( (x-Q.x)*(x-Q.x) + (y-Q.y)*(y-Q.y) + (z-Q.z)*(z-Q.z) );
	}
	
	/** scaled Euclidean distance */
	public double distance(Point3D Q, Point3D scale)
	{
		return Math.sqrt( scale.x*scale.x*(x-Q.x)*(x-Q.x) + scale.y*scale.y*(y-Q.y)*(y-Q.y) + scale.z*scale.z*(z-Q.z)*(z-Q.z) );
		
	}
	
	public boolean equals(Point3D P)
	{
		if ((P.x == x) && (P.y == y) && (P.z == z))
			return true;
		return false;
	}
	
	/**
	 * @return Returns the x.
	 */
	public double getX()
	{
		return x;
	}

	/**
	 * @param x The x to set.
	 */
	public void setX(double x)
	{
		this.x = x;
	}

	/**
	 * @return Returns the y.
	 */
	public double getY()
	{
		return y;
	}

	/**
	 * @param y The y to set.
	 */
	public void setY(double y)
	{
		this.y = y;
	}

	/**
	 * @return Returns the z.
	 */
	public double getZ()
	{
		return z;
	}

	/**
	 * @param z The z to set.
	 */
	public void setZ(double z)
	{
		this.z = z;
	}
	
	public String toString()
	{
		return x + "," + y + "," + z;
	}
}
