package edu.ucla.ccb.graphshifts.graphs;

import java.io.Serializable;
import java.util.Arrays;

import edu.ucla.ccb.graphshifts.MultilevelSegmentation;


/**
 * A HardGraphHierarchy implements the GraphHierarchyModel under the assumption
 *  that all of the nodes in the graph have at most one parent (i.e., the lineage of a
 *  node is fixed and hard).
 * @author jcorso
 *
 */
public class HardGraphHierarchy extends GraphHierarchy implements
		MultilevelSegmentation, Serializable
{
	public static final long serialVersionUID = 1;
	
	public int[] getLabelingFromLevel(int level)
	{
		int[] labels = new int[graphs.get(0).getNumberOfNodes()];
		
		try
		{
		for (int i=0;i<labels.length;i++)
		{
			int index = i;
			for (int L=0;L<level;L++)
			{
				SingleParentProtocol n = (SingleParentProtocol)getLayer(L).getNode(index);
				index = n.getParentIndex();
			}
			labels[i] = index;
		}
		} catch (ClassCastException exc)
		{
			System.err.println("A node in the graph hierarchy does not implement the SingleParentProtocol.");
			System.err.println("Could not get labeling from level, but not FATAL.");
			Arrays.fill(labels,-1);
		}
		
		return labels;
	}
	
	public Object getLevel(int level)
	{
		return getLayer(level);
	}
	
	public final int getNumberOfLevels()
	{
		return getNumberOfLayers();
	}
}
