package edu.ucla.ccb.graphshifts.image;

/** This interface extends the slice-based Image3Protocol to allow pixel access.
 * Since the pixels may be stored in a variety of different formats, a set of functions 
 *  is necessary.
 * @author jcorso
 *
 */
public interface Image3PixelAccess extends Image3Protocol 
{
	public short  getBitsPerPixel();
	
	/* return the "native" format boxed */
	public Object getPixel     (int x, int y, int z);
	public byte   getPixelByte (int x, int y, int z);
	public short  getPixelShort(int x, int y, int z);
	public int    getPixelInt  (int x, int y, int z);
	public float  getPixelFloat(int x, int y, int z);
	
	/* also include min and max access, as floats only... */
	public void   computeMinMax();
	public float  getMinValue();
	public float  getMaxValue();
}
