package edu.ucla.ccb.graphshifts.image;
import java.awt.image.*;

import edu.ucla.ccb.graphshifts.data.Point3D;

/**
 *  The Image3Protocol encapsulates 3D scalar images to provide generic accessability 
 *  to axis-aligned slices.  This does not create the ability to get at individual 
 *  pixel/voxel elements.
 * @author  jcorso
 */
public interface Image3Protocol
{
	public final int SLICE_XY=0;
	/** 
	 * The ZY plane.  This variable is deprecated because its name is confusing since
	 * the z direction is actually indexed as the "x" direction in image operations...
	 * @deprecated
	 */
	public final int SLICE_YZ=1;
	public final int SLICE_ZY=1;
	public final int SLICE_XZ=2;

	public int getWidth();
	public int getHeight();
	public int getDepth();
	public int getNumberOfSlices();
	/**
	 * @return
	 * @uml.property  name="sliceOrientation"
	 */
	public int getSliceOrientation();
	public BufferedImage getSlice(int i);
	/**
	 * @param O
	 * @uml.property  name="sliceOrientation"
	 */
	public void setSliceOrientation(int O);
	
	public boolean isValidVoxel(Point3D P);

	/** is an inspectable colormap associated with this image? */
	public boolean hasColormap();
	public Colormap getColormap();
}
