package edu.ucla.ccb.graphshifts.image;

import java.awt.Color;
import java.beans.PropertyChangeListener;
import java.io.PrintWriter;
import java.io.Serializable;

import com.jgoodies.binding.beans.ExtendedPropertyChangeSupport;


/**
 * An ImageLabel represents a class of labeled data in an image.  
 * This is stored as a JavaBean to allow binding to interface components easily.
 * @author jcorso
 *
 */
public class ImageLabel implements Serializable
{
	private ExtendedPropertyChangeSupport changeSupport = new ExtendedPropertyChangeSupport(this);

	protected int index;
	protected String name;
	protected Color color;
	protected boolean invisible=false;
	
	
	public void addPropertyChangeListener(PropertyChangeListener x) {
		changeSupport.addPropertyChangeListener(x);
	}
	
	public void removePropertyChangeListener(PropertyChangeListener x) {
		changeSupport.removePropertyChangeListener(x);
	}
	
	
	/**
	 * @return Returns the color.
	 */
	public Color getColor()
	{
		return color;
	}
	/**
	 * @param color The color to set.
	 */
	public void setColor(Color newValue)
	{
		Color oldValue = this.color;
		this.color = newValue;
		changeSupport.firePropertyChange("color",oldValue,newValue);
	}
	/**
	 * @return Returns the index.
	 */
	public int getIndex()
	{
		return index;
	}
	/**
	 * @param index The index to set.
	 */
	public void setIndex(int newValue)
	{
		int oldValue = this.index;
		this.index = newValue;
		changeSupport.firePropertyChange("index",oldValue,newValue);
	}
	/**
	 * @return Returns the name.
	 */
	public String getName()
	{
		return name;
	}
	/**
	 * @param name The name to set.
	 */
	public void setName(String newValue)
	{
		String oldValue = this.name;
		this.name = newValue;
		changeSupport.firePropertyChange("name",oldValue,newValue);
	}

	/**
	 * @return Returns the invisible.
	 */
	public boolean isInvisible()
	{
		return invisible;
	}

	/**
	 * @param invisible The invisible to set.
	 */
	public void setInvisible(boolean invisible)
	{
		boolean oldValue = this.invisible;
		this.invisible = invisible;
		changeSupport.firePropertyChange("invisible",oldValue,invisible);
	}
	
	
	
	public void writeAsXML(PrintWriter out)
	{
		out.println("<label color=\"" + 
				getColor().getRed() + "," + getColor().getGreen() +","+getColor().getBlue()+"\""+
				" index=\""+getIndex()+"\""+
				" name=\"" +getName()+"\""+
				" invisible=\""+isInvisible()+"\"" +
				" />");
	}
	
}
