

package edu.ucla.ccb.graphshifts.image;


import net.sourceforge.jiu.data.Gray16Image;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.data.MemoryShortChannelImage;
import net.sourceforge.jiu.data.PixelImage;

/**
 * An implementation of {@link Gray16Image} that keeps the complete image in memory.
 * This class inherits most of its functionality from its parent class
 * {@link MemoryShortChannelImage}, using one <code>short</code> channel.
 * @since 0.11.0
 * @author Jason Corso from Marco Schmidt
 */
public class MemoryGray32Image extends MemoryIntChannelImage 
{
	/**
	 * Creates a new MemoryGray32Image object with the specified resolution.
	 * Simply gives <code>1</code> (for one channel) and the two resolution arguments
	 * to the super constructor (of the parent class {@link MemoryShortChannelImage}).
	 * @param width the horizontal resolution, must be larger than zero
	 * @param height the vertical resolution, must be larger than zero
	 */
	public MemoryGray32Image(int width, int height)
	{
		super(1, width, height);
	}

	public PixelImage createCompatibleImage(int width, int height)
	{
		return new MemoryGray32Image(width, height);
	}

	public Class getImageType()
	{
		return IntegerImage.class;
	}

	public boolean isBlack(int x, int y)
	{
		return getSample(x, y) == 0;
	}

	public boolean isWhite(int x, int y)
	{
		return getSample(x, y) == Integer.MAX_VALUE;
	}

	public void putBlack(int x, int y)
	{
		putSample(x, y, 0);
	}

	public void putWhite(int x, int y)
	{
		putSample(x, y, Integer.MAX_VALUE);
	}
}
