package edu.ucla.ccb.graphshifts.data;

import java.io.Serializable;
// need to refactor this and Point3D to use generics instead

public class Point3I implements Serializable
{
	public int x,y,z;

	public Point3I()
	{
	}
	
	public Point3I(int x, int y, int z)
	{
		this.x = x;
		this.y = y;
		this.z = z;
	}
	
	public void copyContents(Point3I P)
	{
		x = P.x;
		y = P.y;
		z = P.z;
	}
	
	/** Return Euclidean distance... */
	public double distance(Point3I Q)
	{
		return Math.sqrt( (x-Q.x)*(x-Q.x) + (y-Q.y)*(y-Q.y) + (z-Q.z)*(z-Q.z) );
	}
	
	/** scaled Euclidean distance */
	public double distance(Point3I Q, Point3I scale)
	{
		return Math.sqrt( scale.x*scale.x*(x-Q.x)*(x-Q.x) + scale.y*scale.y*(y-Q.y)*(y-Q.y) + scale.z*scale.z*(z-Q.z)*(z-Q.z) );
		
	}
	
	public boolean equals(Point3I P)
	{
		if ((P.x == x) && (P.y == y) && (P.z == z))
			return true;
		return false;
	}
	
	/**
	 * @return Returns the x.
	 */
	public int getX()
	{
		return x;
	}

	/**
	 * @param x The x to set.
	 */
	public void setX(int x)
	{
		this.x = x;
	}

	/**
	 * @return Returns the y.
	 */
	public int getY()
	{
		return y;
	}

	/**
	 * @param y The y to set.
	 */
	public void setY(int y)
	{
		this.y = y;
	}

	/**
	 * @return Returns the z.
	 */
	public int getZ()
	{
		return z;
	}

	/**
	 * @param z The z to set.
	 */
	public void setZ(int z)
	{
		this.z = z;
	}
	
	public String toString()
	{
		return x + "," + y + "," + z;
	}
}
