package edu.ucla.ccb.graphshifts.graphs;

import java.util.ArrayList;

import edu.ucla.ccb.graphshifts.data.DataItem;


/**
 * Stores a hierarchy of graphs as a simple ArrayList.  Linkages between layers 
 *  in the hierarchy are not maintained directly (and must be maintained in the nodes).
 * @author jcorso
 *
 */
public class GraphHierarchy extends DataItem implements GraphHierarchyModel
{
	protected ArrayList<GraphModel> graphs;
	
	public GraphHierarchy()
	{
		graphs = new ArrayList<GraphModel>(1);
	}
	
	public void addGraph(GraphModel g)
	{
		graphs.add(g);
	}
	
	public void addGraph(GraphModel g, int i)
	{
		graphs.add(i,g);
	}
	
	public void clearGraphs()
	{
		graphs.clear();
	}
	
	public Object getData()
	{
		return graphs;
	}
	
	
	public int getNumberOfLayers()
	{
		return graphs.size();
	}
	
	public GraphModel getLayer(int i)
	{
		return graphs.get(i);
	}
	
	public void setGraphForLayer(GraphModel g, int i)
	{
		graphs.ensureCapacity(i+1); // does not actually grow the list though.
		graphs.set(i,g);
	}
	
}
