package edu.ucla.ccb.graphshifts.image;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;

import edu.ucla.ccb.graphshifts.data.Point3D;
import net.sourceforge.jiu.data.IntegerImage;
import net.sourceforge.jiu.gui.awt.ImageCreator;

public class JIUIntegerImage_Image3PixelAccess_Adaptor  implements Image3PixelAccess
{
	IntegerImage I;

	float minValue,maxValue;
	public JIUIntegerImage_Image3PixelAccess_Adaptor(IntegerImage I)
	{
		this.I = I;
	}
	
	public void computeMinMax()
	{
		minValue = 0;
		maxValue = 255;
		
		/*
		minValue = Float.POSITIVE_INFINITY;
		maxValue = Float.NEGATIVE_INFINITY;
		int w,h;
		w = I.getWidth();
		h = I.getHeight();
		for (int y=0;y<h;y++)
			for (int x=0;x<w;x++)
			{
				float v = (float)I.getSample(x, y);
				minValue = (minValue < v) ? minValue : v;
				maxValue = (maxValue > v) ? maxValue : v;
			}
			*/
	}

	public short getBitsPerPixel()
	{
		return (short)I.getBitsPerPixel();
	}

	public Colormap getColormap()
	{
		return null;
	}

	public int getDepth()
	{
		return 1;
	}

	public int getHeight()
	{
		return I.getHeight();
	}

	public float getMaxValue()
	{
		return maxValue;
	}

	public float getMinValue()
	{
		return minValue;
	}

	public int getNumberOfSlices()
	{
		return 1;
	}

	public Object getPixel(int x, int y, int z)
	{
		return I.getSample(x, y);
	}

	public byte getPixelByte(int x, int y, int z)
	{
		return (byte)I.getSample(x, y);
	}

	public float getPixelFloat(int x, int y, int z)
	{
		return (float)I.getSample(x, y);
	}

	public int getPixelInt(int x, int y, int z)
	{
		return I.getSample(x,y);
	}

	public short getPixelShort(int x, int y, int z)
	{
		return (short)I.getSample(x,y);
	}

	public BufferedImage getSlice(int i)
	{
		if (i != 0)
			return null;
		// what a waste :) but it will only be done once for an image...
		Image im = ImageCreator.convertToAwtImage(I,ImageCreator.DEFAULT_ALPHA);
		BufferedImage bim = new BufferedImage(I.getWidth(),I.getHeight(),BufferedImage.TYPE_BYTE_GRAY);
		Graphics2D bufImageGraphics = bim.createGraphics();
		bufImageGraphics.drawImage(im, 0, 0, null);
		return bim;
	}

	public int getSliceOrientation()
	{
		return Image3Protocol.SLICE_XY;
	}

	public int getWidth()
	{
		return I.getWidth();
	}
	
	public IntegerImage getUnderlyingImage()
	{
		return I;
	}

	public boolean hasColormap()
	{
		return false;
	}

	public boolean isValidVoxel(Point3D P)
	{
		if ( (P.x > 0) && (P.x < I.getWidth()) &&
		     (P.y > 0) && (P.y < I.getHeight()) &&
		     (P.z == 0) )
			return true;
		return false;
	}

	public void setSliceOrientation(int O)
	{
	}
	

}
