package edu.ucla.ccb.graphshifts.observers;

import edu.ucla.ccb.graphshifts.graphs.HardGraphHierarchy;

/**
 * A GraphShiftsObserver is basically some object that is interested in knowing when a graph shift has
 *  been taken.  It may want to keep track of the likelihood values, or the shift weights, or output
 *  a movie of the graph shifts operation.  
 * @author jcorso
 *
 */
public interface GraphShiftsObserver {
	
	public void shiftBegin();
	public void shiftEnd();
	public void shiftTaken(int shiftNumber, int shiftLevel, int shiftFrom, int shiftTo, 
			               float shiftWeight, HardGraphHierarchy hierarchy, Object shifter);
}