package edu.ucla.ccb.graphshifts.observers;

import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

import edu.ucla.ccb.graphshifts.graphs.HardGraphHierarchy;
import edu.ucla.ccb.graphshifts.graphs.ThinGraph;

public class ShiftStatistician implements GraphShiftsObserver
{
	String path;
	PrintWriter pw=null;
	
	public ShiftStatistician(String path)
	{
		this.path = path;
	}

	public void shiftBegin()
	{
		try
		{
			pw = new PrintWriter(new BufferedWriter(new FileWriter(path)));
		} catch (IOException e)
		{
			System.err.println("non-fatal: Could not open stats file for writing.");
			pw=null;
			e.printStackTrace();
		}
	}

	public void shiftEnd()
	{
		if (pw != null)
			pw.close();
	}

	public void shiftTaken(int shiftNumber, int shiftLevel, int shiftFrom,
			int shiftTo, float shiftWeight, HardGraphHierarchy graphHierarchy, Object shifter)
	{
		if (pw != null)
		{
			ThinGraph g = (ThinGraph)graphHierarchy.getLayer(shiftLevel);
			int mass = g.NDgetMass(shiftFrom);
			pw.printf("%d\t%d\t%d\t%f\n", shiftNumber, shiftLevel, mass, shiftWeight);
		}
	}

}
