function a = perceptron(D,a0,eta)

% function a = perceptron(D,a0,eta)
%
%  Jason Corso, SUNY at Buffalo, jcorso@buffalo.edu, (c) 2011
%   Use as you want, but no liability or guarantee is implied.
%
%
%  Batch Perceptron on D (not normalized)
%    for dimension d and n samples
%  D is n by d + 1 where the last column of D is
%  Y is n by 1 and is -1 or +1 for classes
%  Assume separability.
%
%    sum_{y in incorrect} -a'y
%
%  for all x in D (column vector)
%
%   a'x > 0
%
%  no margin

Y = D(:,3);
DN = discnormalize(D);
[n,d] = size(DN);


t = 0;
a = a0(:);

plot_debug(1,D,Y,a);
pause;

while (1)
   
    fprintf('iteration %d    %0.4f  %0.4f \t',t,a(1),a(2));
    
    A = repmat(a',n,1);
   
    B = sum(A.*DN,2) <= 0;
    
    fprintf('   %d of %d samples correct\n',sum(B==0),n);
    
    if (sum(B) == 0)
        break;
    end
    
    a = a + (eta .* sum( repmat(B,1,2) .* DN ))';
    a = a / norm(a);
    
    t = t + 1;
    
    hold off;
    plot_debug(1,D,Y,a);
    pause;
    
end


