function h = plot_dataset(D,Y,h)

% function plot_dataset(D,Y,h)
%  Jason Corso, SUNY at Buffalo, jcorso@buffalo.edu, (c) 2011
%   Use as you want, but no liability or guarantee is implied.
%
%
%  Creates a figure and plots the dataset in D
%
%   either the third column of D is the class (-1 or 1) or Y is the class
%  row-wise

if (exist('h','var'))
    figure(h);
else
    h = figure;
end
clf;
a = gca;

set(a,'XLim',[-100,100]);
set(a,'YLim',[-100,100]);
set(a,'XTick',[-100:50:100]);
set(a,'YTick',[-100:50:100]);
set(a,'XGrid','on');
set(a,'YGrid','on');

hold on;

n = size(D,1);

if (~exist('Y','var'))
    
    for i=1:n
        
        if (D(i,3) == -1)
            plot(D(i,1),D(i,2),'ro','MarkerSize',10);
        else
            plot(D(i,1),D(i,2),'b+','MarkerSize',10);
        end
        
    end

else
    
    for i=1:n
        
        if (Y(i) == -1)
            plot(D(i,1),D(i,2),'ro','MarkerSize',10);
        else
            plot(D(i,1),D(i,2),'b+','MarkerSize',10);
        end
        
    end
    
end
