function h = plot_debug(h,D,Y,a,b)

% function plot_debug(h,D,Y,a,b)
%  Jason Corso, SUNY at Buffalo, jcorso@buffalo.edu, (c) 2011
%   Use as you want, but no liability or guarantee is implied.
%
%
%  Creates a figure and plots the dataset in D
%
%   either the third column of D is the class (-1 or 1) or Y is the class
%  row-wise
%
%  a is the solution vector (directly used)
%

if (exist('h','var'))
    figure(h);
    fp = get(h,'Position');
    fp(3:4) = [500 500];
    set(h,'Position',fp);
else
    h = figure;
    fp = get(h,'Position');
    fp(3:4) = [500 500];
    set(h,'Position',fp);
end
clf;
ha = gca;


set(ha,'XLim',[-100,100]);
set(ha,'YLim',[-100,100]);
set(ha,'XTick',[-100:50:100]);
set(ha,'YTick',[-100:50:100]);
set(ha,'XGrid','on');
set(ha,'YGrid','on');
set(ha,'Position',[0.1,0.1,0.8,0.8]);

hold on;

n = size(D,1);

if ( (~exist('Y','var')) || isempty(Y) )
    
    for i=1:n
        
        if (D(i,3) == -1)
            plot(D(i,1),D(i,2),'ro','MarkerSize',10,'LineWidth',2);
        else
            plot(D(i,1),D(i,2),'b+','MarkerSize',10,'LineWidth',2);
        end
        
    end

else
    
    for i=1:n
        
        if (Y(i) == -1)
            plot(D(i,1),D(i,2),'ro','MarkerSize',10,'LineWidth',2);
        else
            plot(D(i,1),D(i,2),'b+','MarkerSize',10,'LineWidth',2);
        end
        
    end
    
end

% we want to highlight the ones that are correct...
if (~exist('b','var'))
    A = repmat(a',n,1);
    DN = discnormalize(D);
    B = sum(A.*DN,2) > 0;
    for i=find(B)
        plot(D(i,1),D(i,2),'go','MarkerSize',18,'LineWidth',2);
    end
    plot_wvector(a);
    
else
    A = repmat(a',n,1);
    DN = discnormalize(D);
    B = sum(A.*DN,2) > b;
    for i=find(B)
        plot(D(i,1),D(i,2),'go','MarkerSize',18,'LineWidth',2);
    end
    plot_wvector(a,b);

end




