function plot_wvector(a,b)

% function plot_wvector(a,b)
%  Jason Corso, SUNY at Buffalo, jcorso@buffalo.edu, (c) 2011
%   Use as you want, but no liability or guarantee is implied.
%
%
%  Plot the solution vector on the grid (assuming a -100:100 grid)
%


hold on;

O = zeros(2,1);

an = a ./ norm(a);
V = O + 500*an;
U = O + -500*an;

plot([O(1);U(1)],[O(2);U(2)],'r','LineWidth',2);
plot([O(1);V(1)],[O(2);V(2)],'b','LineWidth',2);


% rotate an by 90 degrees
anr = [an(2) ; -an(1)];

A = O + 500*anr;
B = O + -500*anr;
plot([A(1);B(1)],[A(2);B(2)],'k','LineWidth',2);


% draw the margin if it exists
if (exist('b','var'))
   
    Ob = O + b*an;
    Ab = Ob + 500*anr;
    Bb = Ob + -500*anr;
    
    plot([Ab(1);Bb(1)],[Ab(2);Bb(2)],'k','LineWidth',1);

    Ob = O - b*an;
    Ab = Ob + 500*anr;
    Bb = Ob + -500*anr;
    
    plot([Ab(1);Bb(1)],[Ab(2);Bb(2)],'k','LineWidth',1);
end

