function a = ssrelaxation(D,a0,eta,b)

% function a = ssrelaxation(D,a0,eta,b)
%
%  Jason Corso, SUNY at Buffalo, jcorso@buffalo.edu, (c) 2011
%   Use as you want, but no liability or guarantee is implied.
%
%
%  Single-Sample Relaxation with the margin on D (not normalized)
%    for dimension d and n samples
%  D is n by d + 1 where the last column of D is
%  Y is n by 1 and is -1 or +1 for classes
%  Assume separability with the margin
%
%    1/2 sum_{y in incorrect} (a'y - b)^2 / ||y||
%
%  for all x in D (column vector)
%
%   a'x > 0
%
%  no margin

Y = D(:,3);
DN = discnormalize(D);
[n,d] = size(DN);


i = 1;  % sample index
t = 0;  % overall iteration counter
a = a0(:);

plot_debug(1,D,Y,a,b);
pause;

count=0;
while (count < n)
   
    count = count + 1;
    
    % we are on sample i, test if it is correct
    val = DN(i,:)*a;
    fprintf('sample %d, val is %0.3f, current count is %d of %d\n',i,val,count,n);
    if (val <= b)
        count = 0;
        
        % train on it
        t = t + 1;
        fprintf('correction iteration %d    %0.4f  %0.4f \n',t,a(1),a(2));
    
        normi = norm(DN(i,:));
        a = a + (eta .* ( (b - DN(i,:)*a)/(normi*normi) * DN(i,:) ) )';
        a = a / norm(a);
        
        hold off;
        plot_debug(1,D,Y,a,b);
        pause;
    end
    
    i = mod(i,n)+1;

end


