% This is a simple script that will let the user make a new dataset
%  for binary problems only
%
% The dataset is a set of 2D points with a label, each. 
%   D = [X Y L] vertical vectors


% set up the figure first.  It will be a square with axes -100:100

h = figure;
a = axes;

set(a,'XLim',[-100,100]);
set(a,'YLim',[-100,100]);
set(a,'XTick',[-100:50:100]);
set(a,'YTick',[-100:50:100]);
set(a,'XGrid','on');
set(a,'YGrid','on');

hold on;


disp('There will be one class of points to acquire.');
Anum = input('How many points in the first class?');

D = ones(3,Anum);

for i=1:Anum
    [x,y] = ginput(1);
    D(:,i) = [x; y; -1];
    plot(x,y,'ro');
end


disp('Done with points in the first class.');

close(h);