function classifier = train_boosted_stump(features, ...
    labels, num_iterations)

% train binary boosted classifier, labels should be -1,1

idx = find(labels~=0);
num_data = length(idx);

w = ones(num_data,1);
w = w/sum(w);

for t = 1:num_iterations
    % learn decision stump based on weighted distribution
    stump = classregtree(features(idx,:), labels(idx), 'method', 'classification',...
        'minparent', num_data-1, 'weights', w);
    
    %  
    % assign weights
    pred_class = zeros(num_data, 1);
    [class_indices] = eval(stump, features(idx,:));
    [~, cls_str] = grp2idx(class_indices);
    for i = 1 : numel(cls_str)
        pred_class(strcmp(class_indices, cls_str(i))) = str2double(cls_str{i});
    end
    
    epsilon_t = sum(w.*(pred_class~=labels(idx)))/sum(w);
    alpha_t = log(1-epsilon_t)-log(epsilon_t);
    
    classifier.c(t).stump = stump;
    classifier.c(t).alpha = alpha_t;
    
    if epsilon_t == 0
        break;
    end

    w = w.*exp(alpha_t*(pred_class~=labels(idx)));
    w = w/sum(w);
end








