function [label, label_conf]= test_boosted_stump(classifier, features)

num_data = size(features,1);
num_iterations = numel(classifier.c);
label_conf = zeros(num_data, 1);

for t = 1:num_iterations
    
    stump = classifier.c(t).stump;
    alpha_t = classifier.c(t).alpha;
    
    class_indices = eval(stump, features);
    [~, cls_str] = grp2idx(class_indices);
    conf = zeros(num_data,1);
    for i = 1 : numel(cls_str)
        conf(strcmp(class_indices, cls_str(i))) = alpha_t*str2double(cls_str{i});
    end
    
    label_conf = label_conf + conf;
end

label = sign(label_conf);
