function beta = BackwardProb(A, B, O)

numStates = size(A,1);
numObs = size(O,1);
beta = zeros(numStates, numObs);

beta(:,numObs) = 1;

for t = numObs-1 : -1 : 1
    for i = 1 : numStates
        beta(i, t) = sum(A(i,:)'.*B(:, O(t+1)).*beta(:,t+1));
    end
end