function [A, B, Pi] = train_HMM(numStates, numSymbols, O)

old_A = ones(numStates)./numStates;
old_B = rand(numStates, numSymbols);
old_Pi = ones(numStates, 1)./numStates;
old_B = old_B ./ repmat(sum(old_B,2), 1, numSymbols);
A = old_A;
B = old_B;
Pi = old_Pi;
counter = 1;
while true
    % the training loop
 
    numSamples = length(O);
    [alpha, pOld]= ForwardProb(old_A, old_B, old_Pi, O{1});
    
    % store Si and Gamma matrix for every sample
    Si = cell(1, numSamples);
    Gamma = cell(1, numSamples);
    
    for sampleInd = 1 : length(O)
        
        numObs = size(O{sampleInd},1);
        Si{sampleInd} = zeros(numStates, numStates, numObs-1);
        alpha = ForwardProb(old_A, old_B, old_Pi, O{sampleInd});
        beta = BackwardProb(old_A, old_B, O{sampleInd});
        
        for t = 1 : numObs - 1
            denom = 0;
            numer = zeros(numStates);
            for i = 1 : numStates
                for j = 1 : numStates
                    numer(i,j) = alpha(i,t)*A(i,j)*B(j, O{sampleInd}(t+1))*beta(j, t+1);
                    denom = denom + alpha(i,t)*A(i,j)*B(j, O{sampleInd}(t+1))*beta(j, t+1);
                end
            end
            Si{sampleInd}(:,:,t) = numer./denom;
        end
        
        Gamma{sampleInd} = zeros(numStates, numObs);
        
        for t = 1 : numObs
            for i = 1 : numStates
                Gamma{sampleInd}(i, t) = alpha(i, t)*beta(i, t)/sum(alpha(:,t).*beta(:,t));
            end
        end
        
        
        
    end
    % end of computing all the gamma and Si matrix
    
    Pi = 0;
    for i = 1 : numSamples
        Pi = Pi+Gamma{i}(:,1);
    end
    Pi = Pi/numSamples;
    
    for i = 1 : numStates
        for j = 1 : numStates
            numerator = 0;
            denominator = 0;
            for k = 1 : numSamples
                numerator = numerator + sum(Si{k}(i, j, 1:end-1));
                denominator = denominator + sum(Gamma{k}(i, 1:end-1));
            end
            A(i,j) = numerator/denominator;
        end
    end
    
    for j = 1 : numStates
        for k = 1 : numSymbols
            numerator = 0;
            denominator = 0;
            for i = 1 : numSamples
                numerator = numerator + sum(Gamma{i}(j, O{i}==k));
                denominator = denominator + sum(Gamma{i}(j, :));
            end
            B(j, k) = numerator/denominator;
        end
    end
    
    [alpha, pNew]= ForwardProb(A, B, Pi, O{1});
    
    if sum(abs(A(:)-old_A(:)))<1E-3 || counter > 1000
        break;
    end
    old_A = A;
    old_B = B;
    old_Pi = Pi;
    counter = counter + 1;
end