<html>

<body>
<table>
	<tr>
		<td valign="top">
			<%-- -------- Include menu HTML code -------- --%>
			<jsp:include page="../menu.html" />
		</td>
		<td>
			<%-- Import the java.sql package --%>
			<%@ page import="java.sql.*"%>
			<%-- -------- Open Connection Code -------- --%>
			<%
			
			Connection conn = null;
			PreparedStatement pstmt = null;
			ResultSet rs = null;
			
			try {
				// Registering MySQL JDBC driver with the DriverManager
				Class.forName("com.mysql.jdbc.Driver");

				// Open a connection to the database using DriverManager
				conn = DriverManager.getConnection(
					"jdbc:mysql://localhost/DemoClasses?" +
					"user=root&password=root");
			%>
			
			<%-- -------- SELECT Statement Code -------- --%>
			<%
				// Create the statement
				Statement statement = conn.createStatement();

				// Use the created statement to SELECT
				// the student attributes FROM the Student table.
				rs = statement.executeQuery("SELECT * FROM Students");
			%>
			
			<!-- Add an HTML table header row to format the results -->
			<table border="1">
			<tr>
				<th>UBID</th>
				<th>First Name</th>
				<th>Middle Name</th>
				<th>Last Name</th>
			</tr>

			<%-- -------- Iteration Code -------- --%>
			<%
				// Iterate over the ResultSet
				while (rs.next()) {
			%>

			<tr>
				<%-- Get the ubid, which is a number --%>
				<td>
					<%=rs.getInt("ubid")%>
				</td>

				<%-- Get the first name --%>
				<td>
					<%=rs.getString("firstName")%>
				</td>

				<%-- Get the middle name --%>
				<td>
					<%=rs.getString("middleName")%>
				</td>

				<%-- Get the last name --%>
				<td>
					<%=rs.getString("lastName")%>
				</td>
			</tr>
			<%
				}
			%>

			<%-- -------- Close Connection Code -------- --%>
			<%
				// Close the ResultSet
				rs.close();

				// Close the Statement
				statement.close();

				// Close the Connection
				conn.close();
			} catch (SQLException sqle) {
			    System.out.println("SQLException: " + sqle.getMessage());
			    System.out.println("SQLState: " + sqle.getSQLState());
			    System.out.println("VendorError: " + sqle.getErrorCode());
			}
			finally {
			    // release resources in a finally{} block
			    // in reverse-order of their creation

			    if (rs != null) {
			        try {
			            rs.close();
			        } catch (SQLException sqle) { } // ignore
			        rs = null;
			    }
			    if (pstmt != null) {
			        try {
			            pstmt.close();
			        } catch (SQLException sqle) { } // ignore
			        pstmt = null;
			    }
			    if (conn != null) {
			        try {
			            conn.close();
			        } catch (SQLException sqle) { } // ignore
			        conn = null;
			    }
			}
			%>
		</table>
		</td>
	</tr>
</table>
</body>

</html>
