package app.actions;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import app.Constants;
import app.forms.LogonForm;

/**
 * Implementation of <strong>Action</strong> that processes a user logoff.
 * 
 * @author Craig R. McClanahan
 * @author Ted Husted
 * @version $Revision: 1.1.1.1 $ $Date: 2002/08/15 15:50:55 $
 */

public final class LogoffAction extends Action {

	// ---------------------------------------------------- Public Methods

	/**
	 * Logoff the user. The event is logged if the debug level is >=
	 * Constants.DEBUG.
	 * 
	 * @param mapping
	 *            The ActionMapping used to select this instance
	 * @param actionForm
	 *            The ActionForm bean for this request (if any)
	 * @param request
	 *            The HTTP request we are processing
	 * @param response
	 *            The HTTP response we are creating
	 * 
	 * @exception IOException
	 *                if an input/output error occurs
	 * @exception ServletException
	 *                if a servlet exception occurs
	 */
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response)
			throws Exception {

		// Extract attributes we will need
		HttpSession session = request.getSession();
		LogonForm user = (LogonForm) session.getAttribute(Constants.USER_KEY);

		// Log this user logoff
		if (user != null) {
			StringBuffer message = new StringBuffer("LogoffAction: User '");
			message.append(user.getUsername());
			message.append("' logged off in session ");
			message.append(session.getId());
			servlet.log(message.toString());
		} else {
			StringBuffer message = new StringBuffer("LogoffAction: User '");
			message.append(session.getId());
			servlet.log(message.toString());
		}

		// Remove user login
		session.removeAttribute(Constants.USER_KEY);

		// Return success
		return (mapping.findForward(Constants.SUCCESS));

	}

} // end LogoffAction
