package app.forms;

import javax.servlet.http.HttpServletRequest;

import org.apache.struts.action.ActionErrors;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;

/**
 * Form bean for the user profile page. This form has the following fields, with
 * default values in square brackets:
 * <ul>
 * <li><b>password</b> - Entered password value
 * <li><b>username</b> - Entered username value
 * </ul>
 * 
 * @author Ted Husted
 * @version $Revision: 1.1.1.1 $ $Date: 2002/08/15 15:50:55 $
 */
public final class LogonForm extends ActionForm {

	// ------------------------------------------------ Instance Variables

	private static final long serialVersionUID = 1L;

	/**
	 * The password.
	 */
	private String password = null;

	/**
	 * The username.
	 */
	private String username = null;

	// ------------------------------------------------------ Properties

	/**
	 * Return the password.
	 */
	public String getPassword() {

		return (this.password);

	}

	/**
	 * Set the password.
	 * 
	 * @param password
	 *            The new password
	 */
	public void setPassword(String password) {

		this.password = password;

	}

	/**
	 * Return the username.
	 */
	public String getUsername() {

		return (this.username);

	}

	/**
	 * Set the username.
	 * 
	 * @param username
	 *            The new username
	 */
	public void setUsername(String username) {

		this.username = username;

	}

	// -------------------------------------------------- Public Methods

	/**
	 * Reset all properties to their default values.
	 * 
	 * @param mapping
	 *            The mapping used to select this instance
	 * @param request
	 *            The servlet request we are processing
	 */
	public void reset(ActionMapping mapping, HttpServletRequest request) {

		setPassword(null);
		setUsername(null);

	}

	/**
	 * Ensure that both fields have been input.
	 * 
	 * @param mapping
	 *            The mapping used to select this instance
	 * @param request
	 *            The servlet request we are processing
	 */
	public ActionErrors validate(ActionMapping mapping,
			HttpServletRequest request) {

		ActionErrors errors = new ActionErrors();

		if ((username == null) || (username.length() < 1))
			errors
					.add("username", new ActionMessage(
							"error.username.required"));

		if ((password == null) || (password.length() < 1))
			errors
					.add("password", new ActionMessage(
							"error.password.required"));

		return errors;

	}

} // End LogonForm
