<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>
<%@ taglib uri="http://struts.apache.org/tags-logic" prefix="logic"%>

<html:html>
<head>
<title><bean:message key="app.title" /></title>
<html:base />
</head>
<body>

<logic:present name="user">
	<h3>Welcome <bean:write name="user" property="username" />!</h3>
</logic:present>

<logic:notPresent scope="session" name="user">
	<h3><bean:message key="welcome.heading" /></h3>
</logic:notPresent>

<html:errors />

<ul>
	<li><html:link forward="logon">Sign in</html:link></li>
	<logic:present name="user">
		<li><html:link forward="logoff">Sign out</html:link></li>
	</logic:present>
</ul>

</body>
</html:html>

<%--

If user is logged in, display "Welcome ${username}!"
Else display "Welcome World!"
Display link to login page; maintain session id if needed.
If user is logged in, display a link to the sign-out page.

Note: Only the minimum required HTML or Struts custom tags 
are used in this example.

--%>