package app.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.ActionMessage;
import org.apache.struts.action.ActionMessages;

import app.forms.CreditCard;
import app.model.Model;

public class Buy extends Action {

	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {

		CreditCard cform = (CreditCard) form;
		String cardNum = cform.getCardNum();

		if (Model.buyWithCard(cardNum))
			return mapping.findForward("success");
		else {
			ActionMessages mgs = new ActionMessages();
			mgs.add("error1", new ActionMessage("errors.detail",
					"Provide another credit card number."));
			this.addErrors(request, mgs);

			return mapping.findForward("failure");
		}
	}
}