package app.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

import app.forms.Bid;
import app.model.Model;

public class CheckBid extends Action {
	public ActionForward execute(ActionMapping mapping, ActionForm form,
			HttpServletRequest request, HttpServletResponse response) {

		Bid bForm = (Bid) form;
		String itemID = bForm.getItemID();
		Integer price = bForm.getBidPrice();
		Integer hBid = Model.currentHighestBid(itemID);

		if (price.intValue() > hBid.intValue()) {
			request.getSession().setAttribute("item", itemID);

			return mapping.findForward("highestBid");
		} else {
			request.getSession().setAttribute("highestBid", hBid);
			request.setAttribute("item", itemID);
			bForm.setBidPrice(null);

			return mapping.findForward("notHighestBid");
		}
	}
}
