<%@ page import="javax.sql.*"%>
<%@ taglib uri="http://struts.apache.org/tags-bean" prefix="bean"%>
<%@ taglib uri="http://struts.apache.org/tags-html" prefix="html"%>

<html:html>
	<head>
		<script type="text/javascript">
			function insertStudent(form) {
				var xmlHttp=new XMLHttpRequest();
				var url="../insertStudent.do?";
				for(var i = 0; i < 4; i++)
					url += form.elements[i].name + "=" + escape(form.elements[i].value) + "&";
				url = url.substr(0,(url.length - 1));

				xmlHttp.onreadystatechange=function() {
					if (xmlHttp.readyState==4) {
						var xmlDoc = xmlHttp.responseXML.documentElement;

						var row = document.getElementById("students").insertRow(2);
						row.id = xmlDoc.getElementsByTagName("id")[0].childNodes[0].nodeValue;

						var ubid = row.insertCell(0);
						ubid.innerHTML = xmlDoc.getElementsByTagName("id")[0].childNodes[0].nodeValue;

						var firstName = row.insertCell(1);
						firstName.innerHTML = xmlDoc.getElementsByTagName("first")[0].childNodes[0].nodeValue;

						var middleName = row.insertCell(2);
						if (xmlDoc.getElementsByTagName("middle")[0].childNodes[0] != null)
						middleName.innerHTML = xmlDoc.getElementsByTagName("middle")[0].childNodes[0].nodeValue;

						var lastName = row.insertCell(3);
						lastName.innerHTML = xmlDoc.getElementsByTagName("last")[0].childNodes[0].nodeValue;
					}
				}
				xmlHttp.open("GET",url,true);
				xmlHttp.send(null);
			}

			function deleteStudent(id) {
				var xmlHttp=new XMLHttpRequest();
				var url="../deleteStudent.do" + "?id=" + id;

				xmlHttp.onreadystatechange=function() {
					if (xmlHttp.readyState==4) {
						var xmlDoc = xmlHttp.responseXML.documentElement;
						var ubid = xmlDoc.getElementsByTagName("id")[0].childNodes[0].nodeValue;
						var rowIndex = document.getElementById(ubid).rowIndex;
						document.getElementById("students").deleteRow(rowIndex);
					}
				}
				xmlHttp.open("GET",url,true);
				xmlHttp.send(null);
			}
		</script>
		<title><bean:message key="app.title" /></title>
		<html:base />
	</head>
<body>

	<!-- in case validation of the entry data fails in the data bean -->
	<html:errors />

	<table>
	<tr>
		<td valign="top">
			<%-- -------- Include menu HTML code -------- --%>
			<jsp:include page="../menu.jsp" />
		</td>
		<td>
			<!-- Add an HTML table header row to format the results -->
			<table id="students">
			<tr>
				<th>UBID</th>
				<th>First Name</th>
				<th>Middle Name</th>
				<th>Last Name</th>
				<th>Action</th>
			</tr>
			<tr>
				<form>
					<td><input name="id" size="10" /></td>
					<td><input name="first" size="15" /></td>
					<td><input name="middle" size="15" /></td>
					<td><input name="last" size="15" /></td>
					<td><input type="button" value="Insert" onclick="insertStudent(this.form)"/></td>
				</form>
			</tr>

			<%-- -------- Iteration Code -------- --%>
			<%
				// Get the studentsRowSet
				RowSet crsStudents = (RowSet) request.getAttribute("crsStudents");
		
				// Iterate over the RowSet
				while (crsStudents.next()) {
			%>

			<tr id="<%=crsStudents.getString(1)%>">
				<html:form action="/updateStudent">

					<%-- Get the ubid, which is a number --%>
					<td>
						<html:text	property="id" size="10"
									value="<%=crsStudents.getString(\"ubid\")%>"
									readonly="true" />
					</td>

					<%-- Get the first name --%>
					<td>
						<html:text	property="first" size="15"
									value="<%=crsStudents.getString(\"firstName\")%>" />
					</td>
	
					<%-- Get the middle name --%>
					<td>
						<html:text	property="middle" size="15"
									value="<%=crsStudents.getString(\"middleName\")%>" />
					</td>
	
					<%-- Get the last name --%>
					<td>
						<html:text	property="last" size="15"
									value="<%=crsStudents.getString(\"lastName\")%>" />
					</td>

					<%-- Button --%>
					<td><html:submit value="Update" /></td>
				</html:form>

				<td><button onclick="deleteStudent(<%=crsStudents.getString(1)%>)">Delete</button></td>
			</tr>
			<%
				}
			%>
			</table>
		</td>
	</tr>
	</table>
</body>
</html:html>