package edu.buffalo.cse510.hibernate;

import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class HibernateUtil {

  private static SessionFactory sessionFactory;

  static {
    try {
      sessionFactory = new Configuration().configure().buildSessionFactory();
    }
    catch (Throwable ex) {
      throw new ExceptionInInitializerError(ex);
    }
  }

  public static SessionFactory getSessionFactory() {

    // Alternatively, we could look up in JNDI here
    return sessionFactory;
  }

  public static void shutdown() {

    // Close caches and connection pools
    getSessionFactory().close();
  }
}