USE mysql;
DROP DATABASE IF EXISTS `hibernate-demo`;
CREATE DATABASE `hibernate-demo` CHARACTER SET 'utf8' COLLATE 'utf8_general_ci';

USE `hibernate-demo`;

--DROP TABLE IF EXISTS `countries`;
CREATE TABLE `countries` (
  countryId int not null auto_increment,
  countryName varchar(50) not null,
  constraint pkCountry primary key (countryId),
  constraint ucCountryName unique (countryName)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--DROP TABLE IF EXISTS `locations`;
CREATE TABLE `locations` (
  locationId int not null auto_increment,
  locationName varchar(50) not null,
  constraint pkLocation primary key (locationId),
  constraint ucLocationName unique (locationName)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--DROP TABLE IF EXISTS `majors`;
CREATE TABLE `majors` (
  majorId int not null auto_increment,
  majorName varchar(50) not null,
  constraint pkMajor primary key(majorId),
  constraint ucMajorName unique(majorName)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--DROP TABLE IF EXISTS `specializations`;
CREATE TABLE `specializations` (
  specializationId int not null auto_increment,
  specializationName varchar(50) not null,
  constraint pkSpecialization primary key(specializationId),
  constraint ucSpecializationName unique(specializationName)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;

--DROP TABLE IF EXISTS `universities`;
CREATE TABLE `universities` (
  universityId int not null auto_increment,
  locationId int not null,
  universityName varchar(150) not null,
  constraint pkUniversity primary key(universityId),
  constraint ucUniversityLocationUniversity unique(locationId,universityName),
  constraint fkUniversityLocationId foreign key (locationId) references locations(locationId),
  index ixUniversityLocationId using btree (locationId)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
