<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ page import="java.util.*" import="org.hibernate.*"
	import="edu.buffalo.cse510.beans.*" import="edu.buffalo.cse510.dao.*"
	import="edu.buffalo.cse510.hibernate.*"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<%@ include file="/includes/header.jsp"%>
<title>Hibernate Demo Iteration #1</title>
<%
  //
  // Use getCurrentSession to get a session associated with the current thread. Since Tomcat
  // does thread pooling, the reuse of a thread may result in the reuse of a previously used
  // hibernate session. This is not ideal for production environments- Tomcat and Hibernate
  // may get "confused" in certain circumstances (which are hard to debug, by the way). So,
  // ideally, you should manage your own Hibernate sessions. See the Hibernate docs for more
  // information.
  //
  Session hsession = HibernateUtil.getSessionFactory().getCurrentSession();
  hsession.setFlushMode(FlushMode.MANUAL);
  Transaction tx = null;
  try {
    tx = hsession.beginTransaction();
    UniversityDAO uniDAO = new UniversityDAO(hsession);
    List<University> uniList = uniDAO.findAll();
    pageContext.setAttribute("uniList", uniList);
    tx.commit();
  }
  catch (Exception e) {
    if (tx != null && tx.isActive()) {
      hsession.getTransaction().rollback();
    }
    throw e;
  }
  finally {
    if (hsession.isOpen()) {
      hsession.close();
    }
  }
%>
</head>

<body>
<div id="wrapper">

<h2>First Hibernate Demo: Test-Driving</h2>

<div class="form-container">

<p>This example should get you started with Hibernate. It exposes
you to the configuration and mapping files as well as the required
libraries to get Hibernate up and running. It also introduces a logging
infra-structre to help you debug your applications. Finally, it provides
a no-brainer data retrieval and display using a straightforward idiom
for retrieving Hibernate persistent objects in JSP. At this time, we use
no servlets or any Struts plumbing. Once you are done, you may <a
	href="<%=session.getServletContext().getContextPath() + "/"%>">go
back to the main page</a>.</p>

In this example, I used the following Hibernate idiom:
<ol>
	<li>Retrieve a Hibernate session</li>
	<li>Set the session flush mode to MANUAL for improved performance</li>
	<li>Start a transaction</li>
	<li>Create a UniversityDAO instance</li>
	<li>Retrieve the list of universities from the DAO</li>
	<li>Save the list so it can be accessed by the view processing
	code (here, in the page context)</li>
	<li>Commit the transaction</li>
	<li>Rollback the transaction on some exception</li>
	<li>Close the session</li>
</ol>

<p>The resulting data is displayed in tabular form below. In order
to display the locationId, I had to <em>traverse</em> the Location bean
referenced by the University bean. This works because Hibernate obtains
the locationId values from the universities table records when loading
data from the database and mapping it to the persistent objects.</p>

<p>Now assume that we wanted to display the locationName. We would
get a LazyInitializationException error (you can try this by jumping to
<a href="iteration2.jsp">Iteration #2</a>, which will throw you to the
application's error page, where you can inspect the error trace). This
happens because Hibernate used a lazy fetching strategy to retrieve
universities from the database and populate the University beans. Under
this strategy, Hibernate does not load the locations records to populate
the Location beans associated with each University bean. In the later
iterations, we will see how to solve this problem.</p>

<table class="resultset">
	<tr class="header">
		<th>universityId</th>
		<th>locationId</th>
		<th>universityName</th>
	</tr>
	<c:set var="id" value="0" />
	<c:set var="style" value="even" />
	<c:forEach var="uni" items="${uniList}">
		<tr class="${style}">
			<td>${uni.universityId}</td>
			<td>${uni.location.locationId}</td>
			<td>${uni.universityName}</td>
		</tr>
		<c:set var="id" value="${id + 1}" />
		<c:if test="${id % 2 == 1}">
			<c:set var="style" value="odd" />
		</c:if>
		<c:if test="${id % 2 == 0}">
			<c:set var="style" value="even" />
		</c:if>
	</c:forEach>
</table>

</div>
</div>
</body>
</html>