package edu.buffalo.cse510.actions;

import java.util.List;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;

import edu.buffalo.cse510.beans.University;
import edu.buffalo.cse510.dao.UniversityDAO;
import edu.buffalo.cse510.exceptions.ModelException;
import edu.buffalo.cse510.hibernate.HibernateUtil;

public class UniversityListAction extends Action {

  public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request,
      HttpServletResponse response) throws ModelException {

    Session hsession = HibernateUtil.getSessionFactory().getCurrentSession();
    hsession.setFlushMode(FlushMode.MANUAL);
    Transaction tx = null;
    try {
      tx = hsession.beginTransaction();
      UniversityDAO uniDAO = new UniversityDAO(hsession);
      List<University> uniList = uniDAO.fetchAllWithLocations();
      request.setAttribute("uniList", uniList);
      tx.commit();
    }
    catch (Exception e) {
      if (tx != null && tx.isActive()) {
        hsession.getTransaction().rollback();
      }
      throw new ModelException(e);
    }
    finally {
      if (hsession.isOpen()) {
        hsession.close();
      }
    }
    return mapping.findForward("success");
  }
}