package edu.buffalo.cse510.actions;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.hibernate.FlushMode;
import org.hibernate.Session;
import org.hibernate.Transaction;

import edu.buffalo.cse510.beans.University;
import edu.buffalo.cse510.dao.UniversityDAO;
import edu.buffalo.cse510.exceptions.ModelException;
import edu.buffalo.cse510.forms.UniversityForm;
import edu.buffalo.cse510.hibernate.HibernateUtil;

public class UniversityUpdateAction extends Action {

  public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request,
      HttpServletResponse response) throws ModelException {

    UniversityForm uniForm = (UniversityForm) form;
    University uni = (University) request.getSession().getAttribute("uni");
    // short-circuit is good for expensive database trips;
    // I illustrate here for pedagogical reasons
    if (uniForm.getUniversityName().trim().equals(uni.getUniversityName())) {
      return mapping.findForward("success");
    }
    // if there was an actual update, let's make sure we commit it
    Session hsession = HibernateUtil.getSessionFactory().getCurrentSession();
    // this is the default flush mode, I used here for clarity
    hsession.setFlushMode(FlushMode.AUTO);
    Transaction tx = null;
    try {
      tx = hsession.beginTransaction();
      // retrieve the session object
      UniversityDAO uniDAO = new UniversityDAO(hsession);
      // reattach the (assumedly) modified object to the Hibernate session
      uniDAO.makePersistent(uni);
      // update the university name
      uni.setUniversityName(uniForm.getUniversityName().trim());
      // commit our changes
      tx.commit();
    }
    catch (Exception e) {
      if (tx != null && tx.isActive()) {
        hsession.getTransaction().rollback();
      }
      throw new ModelException(e);
    }
    finally {
      if (hsession.isOpen()) {
        hsession.close();
      }
    }
    return mapping.findForward("success");
  }
}