package edu.buffalo.cse510.dao;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;

import edu.buffalo.cse510.beans.Location;
import edu.buffalo.cse510.hibernate.GenericDAO;

public class LocationDAO extends GenericDAO<Location, Integer> {

  protected static final Log log = LogFactory.getLog(LocationDAO.class);
  
  public LocationDAO() {

    super();
  }

  public LocationDAO(Session session) {

    super(session);
  }

  public Location findByName(String locationName) {

    Query q = getSession().getNamedQuery("location.findByName");
    q.setString("locationName", locationName);
    return (Location) q.uniqueResult();
  }
}