package edu.buffalo.cse510.dao;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Query;
import org.hibernate.Session;

import edu.buffalo.cse510.beans.University;
import edu.buffalo.cse510.hibernate.GenericDAO;

public class UniversityDAO extends GenericDAO<University, Integer> {

  protected static final Log log = LogFactory.getLog(UniversityDAO.class);

  public UniversityDAO() {

    super();
  }

  public UniversityDAO(Session session) {

    super(session);
  }

  @SuppressWarnings("unchecked")
  public List<University> fetchAllWithLocations() {

    Query q = getSession().getNamedQuery("university.fetchAllWithLocations");
    return (List<University>) q.list();
  }

  public University findByName(String universityName) {

    Query q = getSession().getNamedQuery("university.findByName");
    q.setString("universityName", universityName);
    return (University) q.uniqueResult();
  }
}