/*
 * Copyright 2006 The Apache Software Foundation.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package edu.buffalo.cse510.exceptions;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public final class ExceptionUtils {

  private ExceptionUtils() {

  }

  public static List<Throwable> getExceptions(Throwable cause) {

    List<Throwable> exceptions = new ArrayList<Throwable>(10);
    exceptions.add(cause);

    do {
      Throwable nextCause;
      try {
        Method rootCause = cause.getClass().getMethod("getRootCause", new Class[] {});
        nextCause = (Throwable) rootCause.invoke(cause, new Object[] {});
      }
      catch (Exception e) {
        nextCause = cause.getCause();
      }
      if (cause == nextCause) {
        break;
      }

      if (nextCause != null) {
        exceptions.add(nextCause);
      }

      cause = nextCause;
    }
    while (cause != null);

    return exceptions;
  }

  public static String getFormattedStackTrace(Throwable cause) {

    StringBuffer result = new StringBuffer("");
    if (cause != null) {
      StackTraceElement[] trace = cause.getStackTrace();
      // high-level information about this cause
      result.append(cause.toString());
      // Loop, get, and save four pieces of data for each item in the StackTraceElememt. Each piece
      // of data is saved as a String with an identifier prepended.
      for (int i = 0; i < trace.length; i++) {
        result.append("\n\tat ");
        result.append(trace[i].getClassName());
        result.append(".");
        result.append(trace[i].getMethodName());
        result.append("(");
        result.append(trace[i].getFileName());
        if (trace[i].getLineNumber() > 0) {
          result.append(":");
          result.append(trace[i].getLineNumber());
        }
        result.append(")");
      }
    }
    return result.toString();
  }
}
