<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8" isErrorPage="true"%>
<%@ page
	import="java.util.List,java.io.PrintWriter,edu.buffalo.cse510.exceptions.ExceptionUtils"%>
<html>
<head>
<%@ include file="/includes/header.jsp"%>
<title>SUNY CSE 510 - Error Page</title>
</head>
<body>
<h2>Oooops! This is really embarrassing...</h2>

<p class="errorPresentation">Unfortunately, an unanticipated error
has occurred in the application which caused all your session data to be
lost. We apologize for this problem. You may check the error report
below to see what may have caused the problem. Once you are done, you
may <a href="<%=session.getServletContext().getContextPath() + "/"%>">restart
the application</a>.</p>

<h3>Error Summary</h3>

<%
  Throwable cause = exception;
  if (cause == null) {
    cause = pageContext.getException();
  }
  PrintWriter pw = new PrintWriter(out);
  if ((pageContext != null) && (pageContext.getErrorData() != null)) {
    ErrorData error = pageContext.getErrorData();
    pw.println("<div class=\"errorHeader\">");
    pw.println("HTTP Status...: <span class=\"errorMessage\">" + error.getStatusCode()
        + "</span></br>");
    pw.println("Servlet.......: <span class=\"errorMessage\">" + error.getServletName()
        + "</span></br>");
    pw.println("URI...........: <span class=\"errorMessage\">" + error.getRequestURI()
        + "</span></br>");
    if (cause == null) {
      pw.println("Message.......: <span class=\"errorMessage\">Unknown Error.</span>");
      pw.println("</div>");
    }
  }
%>
<%
  if (cause != null) {
    List<Throwable> exceptions = ExceptionUtils.getExceptions(cause);
    Throwable throwable = (Throwable) exceptions.get(exceptions.size() - 1);
    String exceptionMessage = throwable.getMessage();
    pw.println("Message.......: <span class=\"errorMessage\">" + exceptionMessage + "</span>");
    pw.println("</div>");
    pw.println("<span id=\"errorDetails\" class=\"errorExceptions\">");
    pw.println("<pre class=\"errorExceptionCause\">");
    String fullTrace;
    for (int i = 0; i <= exceptions.size() - 1; i++) {
      throwable = (Throwable) exceptions.get(i);
      fullTrace = ExceptionUtils.getFormattedStackTrace(throwable);
      if (i > 0) {
        pw.print("Caused by: ");
      }
      pw.println(fullTrace);
    }
    pw.println("</pre>");
    pw.println("</div>");
    pw.println("</span>");
  }
%>

<h4>End of Error Report</h4>

<%
  session.invalidate();
%>
</body>
</html>