<%@ page language="java" contentType="text/html; charset=UTF-8"
	pageEncoding="UTF-8"%>
<%@ taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ page import="java.util.*" import="org.hibernate.*"
	import="org.hibernate.stat.*" import="edu.buffalo.cse510.beans.*"
	import="edu.buffalo.cse510.dao.*"
	import="edu.buffalo.cse510.hibernate.*"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN" "http://www.w3.org/TR/html4/loose.dtd">
<html>
<head>
<%@ include file="/includes/header.jsp"%>
<title>Hibernate Demo Iteration #3</title>
<%
  Statistics stats = HibernateUtil.getSessionFactory().getStatistics();
  stats.clear();
  long queryCount = -1;
  long fetchCount = -1;
  //
  // Use getCurrentSession to get a session associated with the current thread. Since Tomcat
  // does thread pooling, the reuse of a thread may result in the reuse of a previously used
  // hibernate session. This is not ideal for production environments- Tomcat and Hibernate
  // may get "confused" in certain circumstances (which are hard to debug, by the way). So,
  // ideally, you should manage your own Hibernate sessions. See the Hibernate docs for more
  // information.
  //
  Session hsession = HibernateUtil.getSessionFactory().getCurrentSession();
  hsession.setFlushMode(FlushMode.MANUAL);
  Transaction tx = null;
  try {
    tx = hsession.beginTransaction();
    UniversityDAO uniDAO = new UniversityDAO(hsession);
    List<University> uniList = uniDAO.findAll();
    pageContext.setAttribute("uniList", uniList);
%>
</head>

<body>
<div id="wrapper">

<a name="top"></a><h2>First Hibernate Demo: Test-Driving</h2>

<div class="form-container">

<p>This example avoids the LazyInitializationException error by
extending the duration of the session so that all view processing is
performed within the session. Every time the view tries to display a
locationName for which the corresponding Location bean has not been
fetched from the database, Hibernate executes a fetch from the database
to retrieve the data and populate the bean. The maximum number of
fetches is thus limited by the total number (N) of records in the
locations table.</p>

<p>Check the <a href="#bottom">bottom of the page</a> for some
statistics collected for the rendering of this view (we cannot compute
the statistics until the view processing is done!).</p>

<p>Once you are done, you may <a
	href="<%=session.getServletContext().getContextPath() + "/"%>">go
back to the main page</a>.</p>

<table class="resultset">
	<tr class="header">
		<th>universityId</th>
		<th>locationId</th>
		<th>locationName</th>
		<th>universityName</th>
	</tr>
	<c:set var="id" value="0" />
	<c:set var="style" value="even" />
	<c:forEach var="uni" items="${uniList}">
		<tr class="${style}">
			<td>${uni.universityId}</td>
			<td>${uni.location.locationId}</td>
			<td>${uni.location.locationName}</td>
			<td>${uni.universityName}</td>
		</tr>
		<c:set var="id" value="${id + 1}" />
		<c:if test="${id % 2 == 1}">
			<c:set var="style" value="odd" />
		</c:if>
		<c:if test="${id % 2 == 0}">
			<c:set var="style" value="even" />
		</c:if>
	</c:forEach>
</table>
<%
  tx.commit();
    fetchCount = stats.getEntityFetchCount();
    queryCount = stats.getQueryExecutionCount();
  }
  catch (Exception e) {
    if (tx != null && tx.isActive()) {
      hsession.getTransaction().rollback();
    }
    throw e;
  }
  finally {
    if (hsession.isOpen()) {
      hsession.close();
    }
  }
%>
<br/><br/>
<a name="bottom">Execution Statistics:</a> 

<p>The number of queries executed is <b><%=queryCount%></b> and the
number of fetches from the database is <b><%=fetchCount%></b>. Note that
there are 3217 records in universities and 138 in locations. This is not
entirely bad (could have been 3218 queries + fetches in total). However,
we still have a high overhead on the number of queries executed by
Hibernate (N+1). <a href="#top">Go back to the top.</a></p>

</div>
</div>
</body>
</html>