<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet version="2.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html" />

	<xsl:template match="/">
		<html>
			<head>
				<title>student List</title>
			</head>
			<body>
				<table border="3">
					<tr>
						<td>
							<b> Major </b>
						</td>
						<td>
							<b> Students </b>
						</td>
					</tr>
					<xsl:for-each select="//student[not(major=preceding-sibling::student/major)]/major">
						<xsl:if test="position() mod 2 = 0">
							<tr bgcolor="#AFD775">
								<td>
									<xsl:value-of select="." />
								</td>
								<td>
									<xsl:apply-templates select="." />
								</td>
							</tr>
						</xsl:if>

						<xsl:if test="position() mod 2 = 1">
							<tr bgcolor="#95CBE9">
								<td>
									<xsl:value-of select="." />
								</td>
								<td>
									<xsl:apply-templates select="." />
								</td>
							</tr>
						</xsl:if>
					</xsl:for-each>
				</table>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="major">
		<table border="3">
			<tr>
				<td>
					<b> Name </b>
				</td>
				<td>
					<b> Courses </b>
				</td>
			</tr>
			<xsl:apply-templates select="/students/student[major=current()]" />
		</table>
	</xsl:template>

	<xsl:template match="student">
		<tr>
			<td>
				<xsl:value-of select="name/last" />
				,
				<xsl:value-of select="name/first" />
			</td>
			<td>
				<table border="1">
					<tr>
						<td>
							<b> Number </b>
						</td>
						<td>
							<b> Units </b>
						</td>
					</tr>
					<xsl:apply-templates select="courses/course" />
				</table>
			</td>
		</tr>
	</xsl:template>

	<xsl:template match="course">
		<tr>
			<td>
				<xsl:value-of select="number" />
			</td>
			<td>
				<xsl:value-of select="units" />
			</td>
		</tr>
	</xsl:template>

</xsl:stylesheet>
