<?xml version="1.0"?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	version="1.0">
	<xsl:output method="html" />

	<xsl:template match="/">
		<html>
			<head>
				<title>student List</title>
			</head>
			<body>
				<table border="3">
					<tr>
						<td>
							<b> # </b>
						</td>
						<td>
							<b> Name </b>
						</td>
						<td>
							<b> Major </b>
						</td>
						<td>
							<b> Course </b>
						</td>
					</tr>
					<xsl:for-each select="students/student">
						<xsl:if test="position() mod 2 = 0">
							<tr bgcolor="#AFD775">
								<td>
									<xsl:number value="position()" format="1" />
								</td>
								<xsl:apply-templates select="." />
							</tr>
						</xsl:if>

						<xsl:if test="position() mod 2 = 1">
							<tr bgcolor="#95CBE9">
								<td>
									<xsl:number value="position()" format="1" />
								</td>
								<xsl:apply-templates select="." />
							</tr>
						</xsl:if>
					</xsl:for-each>
				</table>
			</body>
		</html>
	</xsl:template>

	<xsl:template match="student">
		<td>
			<xsl:value-of select="name/last" />
			,
			<xsl:value-of select="name/first" />
		</td>
		<td>
			<xsl:value-of select="major" />
		</td>
		<td>
			<table border="1">
				<tr>
					<td>
						<b> Number </b>
					</td>
					<td>
						<b> Units </b>
					</td>
				</tr>
				<xsl:apply-templates select="courses/course" />
			</table>
		</td>
	</xsl:template>

	<xsl:template match="course">
		<tr>
			<td>
				<xsl:value-of select="number" />
			</td>
			<td>
				<xsl:value-of select="units" />
			</td>
		</tr>
	</xsl:template>

</xsl:stylesheet>
