/*
 * Decompiled with CFR 0.152.
 */
package dialog;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import mdgawt.CharacterSelector;
import tm2.Alphabet;
import tm2.Ins;
import tm2.TMG;

public class AlphabetDialog
extends Dialog
implements ActionListener,
ItemListener {
    TMG tmg;
    CharacterSelector blank;
    CharacterSelector wildcard;
    CharacterSelector copy;
    CharacterSelector lambda;
    Panel p1;
    Panel p2;
    Panel p3;
    Panel p4;
    Panel p5;
    Panel p6;
    Label lc;
    Label l;
    Label cs;
    Button b;
    Button apply;

    public AlphabetDialog(TMG tMG) {
        super(tMG.myFrame, "Alphabet", true);
        this.tmg = tMG;
        this.setResizable(false);
        this.setLayout(new BorderLayout(4, 4));
        ((Component)this).setLocation(10, 10);
        Ins.alphabet.updateCheckboxes();
        String string = Ins.alphabet.getAlphabet();
        ((Component)this).setSize(600, (int)Math.sqrt(Alphabet.ap.getComponentCount()) * 24 + 200);
        this.p1 = new Panel();
        this.p1.setSize(600, 24);
        this.p1.setLayout(new FlowLayout(1, 4, 4));
        String[] stringArray = new String[]{"Select characters", "Select digits", "Select used", "Select all", "Unselect all", "Apply", "Ok", "Cancel"};
        int n = 0;
        while (n < 8) {
            this.b = new Button(stringArray[n]);
            this.b.addActionListener(this);
            this.p1.add(this.b);
            ++n;
        }
        this.p2 = new Panel();
        this.p2.setSize(600, 16);
        this.p2.setLayout(new FlowLayout(1, 0, 0));
        this.blank = new CharacterSelector(string);
        this.copy = new CharacterSelector(string);
        this.wildcard = new CharacterSelector(string);
        this.lambda = new CharacterSelector(string);
        this.blank.setSelected(Alphabet.blank);
        this.copy.setSelected(Alphabet.copy);
        this.wildcard.setSelected(Alphabet.wildcard);
        this.lambda.setSelected(Alphabet.lambda);
        this.p2.add(new Label("Blank"));
        this.p2.add(this.blank);
        if (TMG.copysOn) {
            this.p2.add(new Label("   "));
            this.p2.add(new Label("Copy"));
            this.p2.add(this.copy);
        }
        if (TMG.wildcardsOn) {
            this.p2.add(new Label("   "));
            this.p2.add(new Label("Wildcard"));
            this.p2.add(this.wildcard);
        }
        if (TMG.getType() == 1) {
            this.p2.add(new Label("   "));
            this.p2.add(new Label("Lambda"));
            this.p2.add(this.lambda);
        }
        this.p4 = new Panel();
        this.p4.setSize(600, 16);
        this.p4.setLayout(new FlowLayout(1, 0, 0));
        this.p4.add(new Label("Current used -> " + TMG.getUsedAlphabet()));
        this.p3 = new Panel();
        this.p3.setSize(600, 16);
        this.p3.setLayout(new FlowLayout(1, 0, 0));
        this.lc = new Label("Current alphabet ->  " + string);
        this.p3.add("Center", this.lc);
        this.p6 = new Panel();
        this.p6.setSize(600, 16);
        this.p6.setLayout(new FlowLayout(1, 0, 0));
        this.cs = new Label("Current selected -> " + Ins.alphabet.getSelected());
        this.p6.add("Center", this.cs);
        this.p5 = new Panel();
        this.p5.setSize(600, 72);
        this.p5.setLayout(new GridLayout(5, 1, 0, 0));
        this.p5.add(this.p4);
        this.p5.add(this.p3);
        this.p5.add(this.p6);
        this.p5.add(this.p2);
        this.p5.add(this.p1);
        this.add("Center", Alphabet.ap);
        this.add("South", this.p5);
        Ins.alphabet.addItemListener(this);
        ((Component)this).setVisible(true);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getSource();
        ((Checkbox)object).getLabel();
        ((Checkbox)object).getState();
        this.cs.setText("Current selected -> " + Ins.alphabet.getSelected());
        this.p6.doLayout();
        String string = Ins.alphabet.getSelected();
        this.blank.setChars(string);
        this.wildcard.setChars(string);
        this.copy.setChars(string);
        this.lambda.setChars(string);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object instanceof Button) {
            String string = ((Button)object).getLabel();
            if (string.equals("Cancel")) {
                this.dispose();
            } else if (string.equals("Apply") || string.equals("Ok")) {
                Ins.alphabet.apply();
                String string2 = Ins.alphabet.getAlphabet();
                this.blank.setChars(string2);
                this.wildcard.setChars(string2);
                this.copy.setChars(string2);
                this.lambda.setChars(string2);
                this.lc.setText("Current alphabet ->  " + string2);
                this.p3.doLayout();
                Alphabet.blank = this.blank.getSelected();
                Alphabet.copy = this.copy.getSelected();
                Alphabet.wildcard = this.wildcard.getSelected();
                Alphabet.lambda = this.lambda.getSelected();
                if (string.equals("Ok")) {
                    this.dispose();
                }
            } else if (string.equals("Select characters")) {
                Ins.alphabet.selectCharacters();
            } else if (string.equals("Select digits")) {
                Ins.alphabet.selectDigits();
            } else if (string.equals("Select all")) {
                Ins.alphabet.setAll(true);
            } else if (string.equals("Select used")) {
                Ins.alphabet.selectUsed();
            } else if (string.equals("Unselect all")) {
                Ins.alphabet.setAll(false);
            }
            this.cs.setText("Current selected -> " + Ins.alphabet.getSelected());
            this.p6.doLayout();
        }
    }
}

