/*
 * Decompiled with CFR 0.152.
 */
package dialog;

import java.awt.Button;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import mdgawt.MyCanvas;
import mdgawt.WarningDialog;
import tm2.Alphabet;
import tm2.Ins;
import tm2.TMG;
import tm2.Tape;

public class InsDialog
extends Dialog
implements ActionListener,
ItemListener {
    Choice[] directions = new Choice[Tape.getNumTapes()];
    Choice[] reads = new Choice[Tape.getNumTapes()];
    Choice[] writes = new Choice[Tape.getNumTapes()];
    Ins ins;

    public InsDialog(MyCanvas myCanvas, Ins ins) {
        super(myCanvas.myFrame, "Instruction", true);
        this.ins = ins;
        ((Component)this).setSize(300, (Tape.getNumTapes() + 3) * 40);
        this.setResizable(false);
        Point point = myCanvas.getLocation();
        Dimension dimension = myCanvas.getSize();
        String string = Ins.alphabet.getAlphabet();
        ((Component)this).setLocation(point.x + dimension.width / 2 - 150, point.y + dimension.height / 2 - (Tape.getNumTapes() + 2) * 20);
        this.setLayout(new GridLayout(Tape.getNumTapes() + 2, 1, 5, 5));
        int n = TMG.getType();
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(1, 5, 5));
        panel.add(new Label("Tape"));
        panel.add(new Label("Read"));
        if (n == 3 || n == 2) {
            panel.add(new Label("Write"));
            panel.add(new Label("Direction"));
        }
        this.add(panel);
        int n2 = 0;
        while (n2 < Tape.getNumTapes()) {
            panel = new Panel();
            this.reads[n2] = new Choice();
            int n3 = 0;
            while (n3 < string.length()) {
                this.reads[n2].add(String.valueOf(string.charAt(n3)));
                ++n3;
            }
            this.reads[n2].select(String.valueOf(this.ins.getRead(n2)));
            this.writes[n2] = new Choice();
            int n4 = 0;
            while (n4 < string.length()) {
                this.writes[n2].add(String.valueOf(string.charAt(n4)));
                ++n4;
            }
            this.writes[n2].select(String.valueOf(this.ins.getWrite(n2)));
            this.directions[n2] = new Choice();
            this.directions[n2].add("Right");
            this.directions[n2].add("Stay");
            if (n != 2 || n2 != 0) {
                this.directions[n2].add("Left");
            }
            if (this.ins.getDirection(n2) == 'R') {
                this.directions[n2].select("Right");
            } else if (this.ins.getDirection(n2) == 'L') {
                this.directions[n2].select("Left");
            } else {
                this.directions[n2].select("Stay");
            }
            panel.add(new Label(String.valueOf(Integer.toString(n2 + 1))));
            panel.add(this.reads[n2]);
            if (n == 3 || n == 2) {
                panel.add(this.writes[n2]);
                panel.add(this.directions[n2]);
            }
            this.add(panel);
            ++n2;
        }
        if (n == 2) {
            this.writes[0].setEnabled(false);
            this.reads[0].addItemListener(this);
            this.writes[1].addItemListener(this);
            this.directions[1].addItemListener(this);
        }
        panel = new Panel();
        Button button = new Button("Ok");
        button.addActionListener(this);
        panel.add(button);
        button = new Button("Cancel");
        button.addActionListener(this);
        panel.add(button);
        this.add(panel);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.writes[0].select(this.reads[0].getSelectedItem());
        if (this.directions[1].getSelectedItem().equals("Left")) {
            this.writes[1].select(String.valueOf(Alphabet.blank));
            this.writes[1].setEnabled(false);
            return;
        }
        this.writes[1].setEnabled(true);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        char[] cArray = new char[5];
        if (object instanceof Button) {
            String string = ((Button)object).getLabel();
            if (string.equals("Ok")) {
                int n = 0;
                while (n < Tape.getNumTapes()) {
                    cArray[n] = this.reads[n].getSelectedItem().charAt(0);
                    ++n;
                }
                if (((TMG)this.ins.getOwner()).changeIns(this.ins, cArray)) {
                    int n2 = 0;
                    while (n2 < Tape.getNumTapes()) {
                        this.ins.setRead(n2, cArray[n2]);
                        this.ins.setWrite(n2, this.writes[n2].getSelectedItem().charAt(0));
                        this.ins.setDirection(n2, this.directions[n2].getSelectedItem().charAt(0));
                        ++n2;
                    }
                    this.ins.getOwner().fullRepaint();
                    this.dispose();
                    return;
                }
                new WarningDialog(this.ins.getOwner().myFrame, "", "This is not a non-deterministic machine");
                return;
            }
            if (string.equals("Cancel")) {
                this.dispose();
            }
        }
    }
}

