/*
 * Decompiled with CFR 0.152.
 */
package mdgawt;

import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import mdgawt.CharacterSelectorWin;
import mdgawt.PlusMinusButton;

public class CharacterSelector
extends Panel
implements Runnable,
MouseListener {
    public static final int UP = 1;
    public static final int DOWN = -1;
    private int dir;
    private String chars = new String(" ");
    private int selected;
    private int numChars;
    private Thread tt;
    CharacterSelectorWin csw = new CharacterSelectorWin(this);
    PlusMinusButton plusButton;
    PlusMinusButton minusButton;
    private boolean isRunning;

    public CharacterSelector(String string) {
        this.setChars(string);
        this.setSize(52, 17);
        this.setLayout(new FlowLayout(0, 0, 0));
        this.plusButton = new PlusMinusButton(1);
        this.plusButton.addMouseListener(this);
        this.add(this.plusButton);
        this.add(this.csw);
        this.minusButton = new PlusMinusButton(2);
        this.minusButton.addMouseListener(this);
        this.add(this.minusButton);
    }

    public void setChars(String string) {
        if (string == null) {
            string = new String(" ");
        }
        if (string.length() == 0) {
            string = new String(" ");
        }
        char c = this.getSelected();
        this.chars = new String(string);
        this.numChars = string.length();
        this.setSelected(c);
        this.csw.repaint();
    }

    public void setSelected(char c) {
        this.selected = 0;
        int n = 0;
        while (n < this.numChars) {
            if (this.chars.charAt(n) == c) {
                this.selected = n;
                this.csw.repaint();
            }
            ++n;
        }
    }

    public char getSelected() {
        return this.chars.charAt(this.selected);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.plusButton.addMouseListener(mouseListener);
        this.minusButton.addMouseListener(mouseListener);
    }

    public void start() {
        this.tt = new Thread(this);
        this.tt.start();
    }

    public void stop() {
        this.isRunning = false;
        this.csw.repaint();
    }

    public void run() {
        int n = 400;
        this.isRunning = true;
        while (this.isRunning) {
            if (n > 0) {
                n -= n / 5;
            }
            if (this.selected + this.dir < this.numChars && this.selected + this.dir >= 0) {
                this.selected += this.dir;
            }
            this.csw.repaint();
            try {
                Thread.sleep(n + 5 - Math.min(this.numChars / 200, 5));
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Object object = mouseEvent.getSource();
        if (object instanceof PlusMinusButton) {
            PlusMinusButton plusMinusButton = (PlusMinusButton)object;
            this.dir = plusMinusButton.getDirection() == 1 ? 1 : -1;
            this.start();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.stop();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.stop();
    }
}

