/*
 * Decompiled with CFR 0.152.
 */
package tm2;

import java.awt.Checkbox;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ItemListener;
import tm2.TMG;

public class Alphabet {
    private static int minimumCharacterValue = 32;
    private static int maximumCharacterValue = 91;
    private static int alphaSize = 60;
    private static Checkbox[] checkboxes;
    private static String alphabet;
    public String wildcards = new String();
    public static char blank;
    public static char wildcard;
    public static char copy;
    public static char lambda;
    public static Panel ap;

    public Alphabet() {
        Alphabet.setupPanel();
    }

    public void setWildcards(String string) {
        this.wildcards = string;
    }

    public String getWildcards() {
        return this.wildcards;
    }

    public static void setupPanel() {
        alphaSize = maximumCharacterValue - minimumCharacterValue + 1;
        checkboxes = new Checkbox[alphaSize];
        ap = new Panel();
        int n = (int)Math.sqrt(alphaSize) + 1;
        ap.setLayout(new GridLayout(n, n));
        int n2 = minimumCharacterValue;
        int n3 = 0;
        while (n2 <= maximumCharacterValue) {
            int n4 = n3++;
            Checkbox checkbox = new Checkbox(String.valueOf((char)n2));
            Alphabet.checkboxes[n4] = checkbox;
            ap.add(checkbox);
            ++n2;
        }
    }

    public static int getMin() {
        return minimumCharacterValue;
    }

    public static int getMax() {
        return maximumCharacterValue;
    }

    public static void setMin(int n) {
        minimumCharacterValue = n;
        Alphabet.setupPanel();
    }

    public static void setMax(int n) {
        maximumCharacterValue = n;
        Alphabet.setupPanel();
    }

    public void addItemListener(ItemListener itemListener) {
        int n = 0;
        while (n < alphaSize) {
            checkboxes[n].addItemListener(itemListener);
            ++n;
        }
    }

    public char getBlank() {
        return blank;
    }

    public String getAlphabet() {
        return new String(alphabet);
    }

    public String getSelected() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        while (n < alphaSize) {
            if (checkboxes[n].getState()) {
                stringBuffer.append(checkboxes[n].getLabel().charAt(0));
            }
            ++n;
        }
        return new String(stringBuffer);
    }

    public void setCheckboxes(String string) {
        if (string == null) {
            System.out.println("str = null");
        }
        int n = 0;
        while (n < alphaSize) {
            if (string.indexOf(checkboxes[n].getLabel().charAt(0)) == -1) {
                checkboxes[n].setState(false);
            } else {
                checkboxes[n].setState(true);
            }
            ++n;
        }
    }

    public void updateCheckboxes() {
        this.setCheckboxes(alphabet);
    }

    public void apply() {
        alphabet = this.getSelected();
    }

    public void setAll(boolean bl) {
        int n = 0;
        while (n < alphaSize) {
            checkboxes[n].setState(bl);
            ++n;
        }
    }

    public void selectUsed() {
        this.setCheckboxes(TMG.getUsedAlphabet());
    }

    public void selectDigits() {
        int n = 0;
        while (n < alphaSize) {
            char c = checkboxes[n].getLabel().charAt(0);
            if (c >= '0' && c <= '9') {
                checkboxes[n].setState(true);
            }
            ++n;
        }
    }

    public void selectCharacters() {
        int n = 0;
        while (n < alphaSize) {
            char c = checkboxes[n].getLabel().charAt(0);
            if (c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') {
                checkboxes[n].setState(true);
            }
            ++n;
        }
    }

    public void setAlphabet(String string) {
        this.setCheckboxes(string);
        this.apply();
    }

    public void fromString(String string) {
        int n = string.length();
        blank = string.charAt(n - 3);
        wildcard = string.charAt(n - 2);
        copy = string.charAt(n - 1);
        this.setAlphabet(string);
    }

    public String toString() {
        return new String(alphabet);
    }

    static {
        alphabet = new String(" ab01*@");
        blank = (char)32;
        wildcard = (char)42;
        copy = (char)64;
        lambda = (char)64;
    }
}

