/*
 * Decompiled with CFR 0.152.
 */
package tm2;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import mdgawt.MyComponent;
import tm2.Ins;
import tm2.State;
import tm2.Tape;

public class Marker
extends MyComponent {
    public static Color color = Color.green;
    public static Color deadColor = Color.red;
    public static Color textColor = Color.black;
    public static boolean historyOn = true;
    private StringBuffer history = new StringBuffer("");
    private boolean alive = true;

    public Marker(String string) {
        super(string, 0, 0);
    }

    public Marker(String string, State state) {
        super(string, 0, 0);
        this.setSize(15, 34);
        this.setState(state);
    }

    public void setState(Ins ins) {
        int n = 0;
        while (n < Tape.getNumTapes()) {
            this.history.append(ins.getRead(n));
            ++n;
        }
        this.setState(ins.getTo());
    }

    public void addLink(MyComponent myComponent) {
        this.removeLink(this.getLink(0));
        super.addLink(myComponent);
    }

    public State getState() {
        return (State)this.getLink(0);
    }

    private void setState(State state) {
        this.addLink(state);
        Dimension dimension = this.getSize();
        this.setLocation(state.getCenter().x - dimension.width / 2, state.getLocation().y - dimension.height - 4);
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void kill() {
        this.alive = false;
    }

    public String getHistory() {
        return this.history.toString();
    }

    public void setHistoryOn(boolean bl) {
        historyOn = bl;
    }

    public boolean getHistoryOn() {
        return historyOn;
    }

    public void paint(Graphics graphics) {
        if (graphics == null) {
            return;
        }
        Point point = this.getLocation();
        Point point2 = this.getCenter();
        Dimension dimension = this.getSize();
        if (this.alive) {
            graphics.setColor(color);
        } else {
            graphics.setColor(deadColor);
        }
        graphics.fillRect(point.x, point.y, dimension.width - 1, dimension.height - 14);
        int n = 0;
        while (n < 14) {
            graphics.drawLine(point2.x - 13 + n, point.y + dimension.height - 14 + n, point2.x + 13 - n, point.y + dimension.height - 14 + n);
            ++n;
        }
        graphics.setColor(Color.black);
        graphics.drawLine(point.x, point.y, point.x, point.y + dimension.height - 14);
        graphics.drawLine(point.x + dimension.width - 1, point.y, point.x + dimension.width - 1, point.y + dimension.height - 14);
        graphics.drawLine(point.x, point.y, point.x + dimension.width - 1, point.y);
        graphics.drawLine(point2.x - 13, point.y + dimension.height - 14, point2.x, point.y + dimension.height - 1);
        graphics.drawLine(point2.x + 13, point.y + dimension.height - 14, point2.x, point.y + dimension.height - 1);
        graphics.drawLine(point2.x + 13, point.y + dimension.height - 14, point.x + dimension.width - 1, point.y + dimension.height - 14);
        graphics.drawLine(point2.x - 13, point.y + dimension.height - 14, point.x, point.y + dimension.height - 14);
    }
}

