/*
 * Decompiled with CFR 0.152.
 */
package tm2;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.Panel;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import mdgawt.ArrowButton;
import mdgawt.SmallCounter;
import tm2.Alphabet;
import tm2.Cell;
import tm2.Ins;
import tm2.Tape;
import tm2.TapeWin;

class TL
extends Panel
implements Runnable,
ItemListener {
    public String currentFilename = "Untitled";
    public Cell head;
    public Cell selected;
    public Cell lockedAt;
    private boolean locked = false;
    private boolean isRunning = false;
    public char runDirection;
    private Thread tt;
    private SmallCounter mc = new SmallCounter(0, 10);
    public TapeWin tw;
    private int index;

    public TL(int n) {
        this.setBackground(Tape.tape);
        this.index = n;
        this.setSize(632, 17);
        this.setLayout(new BorderLayout(0, 0));
        Panel panel = new Panel();
        panel.setLayout(new FlowLayout(0, 0, 0));
        panel.add(new SmallCounter(this.index));
        ArrowButton arrowButton = new ArrowButton(1);
        arrowButton.addItemListener(this);
        panel.add(arrowButton);
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout(0, 0, 0));
        arrowButton = new ArrowButton(2);
        arrowButton.addItemListener(this);
        panel2.add(arrowButton);
        panel2.add(this.mc);
        this.tw = new TapeWin(this);
        this.add("West", panel);
        this.add("Center", this.tw);
        this.add("East", panel2);
        this.reset();
        this.lockedAt = this.head;
    }

    public void save() {
        this.save(this.currentFilename);
    }

    public void save(String string) {
        this.currentFilename = string;
        Cell cell = this.head;
        String string2 = new String("");
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            while (cell.prev != null) {
                cell = cell.prev;
            }
            while (cell.next != null && cell.data == Alphabet.blank) {
                cell = cell.next;
            }
            while (cell.next != null) {
                if ((string2 = new String(String.valueOf(string2) + cell.data)).length() == 80) {
                    printWriter.println(string2);
                    string2 = new String("");
                } else if (cell.data == '\n') {
                    printWriter.println(string2.substring(0, string2.length() - 1));
                    string2 = new String("");
                }
                cell = cell.next;
            }
            if (string2.length() > 0) {
                printWriter.println(string2);
            }
            printWriter.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
    }

    public synchronized void reset() {
        Cell cell;
        Cell cell2 = new Cell(Ins.alphabet.getBlank(), null, null);
        cell2.next = cell = new Cell(Ins.alphabet.getBlank(), cell2, null);
        if (this.head != null) {
            while (this.head.prev != null) {
                this.head = this.head.prev;
            }
            while (this.head.next != null) {
                this.head = this.head.next;
                this.head.prev.next = null;
                this.head.prev = null;
            }
            System.gc();
        }
        int n = 0;
        while (n < 100) {
            cell = cell.next = new Cell(Ins.alphabet.getBlank(), cell, null);
            if (n == 50) {
                this.head = cell;
            }
            ++n;
        }
        this.selected = this.tw.pick = this.head;
        this.lockedAt = this.tw.pick;
        this.mc.setValue(0);
        this.repaint();
    }

    public synchronized char read() {
        return this.head.data;
    }

    public void revLock() {
        this.locked = !this.locked;
        if (this.locked) {
            this.lockedAt = this.head;
            this.tw.repaint();
        }
    }

    public synchronized void write(char c) {
        this.head.data = c;
    }

    public synchronized void update() {
        this.tw.paint(this.tw.getGraphics());
        this.mc.paint(this.mc.getGraphics());
    }

    public void start() {
        this.tt = new Thread(this);
        this.tt.start();
    }

    public void stop() {
        this.isRunning = false;
    }

    public void run() {
        this.isRunning = true;
        int n = 80;
        while (this.isRunning) {
            this.moveLock(this.runDirection);
            this.tw.paint(this.tw.getGraphics());
            try {
                Thread.sleep(n);
            }
            catch (InterruptedException interruptedException) {}
            if (n <= 0) continue;
            n -= 4;
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        Object object = itemEvent.getItem();
        if (object instanceof ArrowButton) {
            if (itemEvent.getStateChange() == 1) {
                this.runDirection = ((ArrowButton)object).getDirection() == 1 ? (char)82 : (char)76;
                this.start();
                return;
            }
            this.stop();
        }
    }

    public void moveLock(char c) {
        if (c == 'R') {
            if (this.lockedAt.next == null) {
                this.lockedAt.next = new Cell(Ins.alphabet.getBlank(), this.lockedAt, null);
            }
            this.lockedAt = this.lockedAt.next;
            return;
        }
        if (this.lockedAt.prev == null) {
            this.lockedAt.prev = new Cell(Ins.alphabet.getBlank(), null, this.lockedAt);
        }
        this.lockedAt = this.lockedAt.prev;
    }

    public void moveSelected(char c) {
        if (c == 'R') {
            if (this.selected.next == null) {
                this.selected.next = new Cell(Ins.alphabet.getBlank(), this.selected, null);
            }
            this.selected = this.selected.next;
            return;
        }
        if (this.selected.prev == null) {
            this.selected.prev = new Cell(Ins.alphabet.getBlank(), null, this.selected);
        }
        this.selected = this.selected.prev;
    }

    public synchronized void runRight() {
        if (this.head.next == null) {
            this.head.next = new Cell(Ins.alphabet.getBlank(), this.head, null);
        }
        this.head = this.head.next;
        if (this.locked) {
            this.lockedAt = this.head;
        }
        if (!this.head.used) {
            this.head.used = true;
            this.mc.adv();
        }
    }

    public synchronized void runLeft() {
        if (this.head.prev == null) {
            this.head.prev = new Cell(Ins.alphabet.getBlank(), null, this.head);
        }
        this.head = this.head.prev;
        if (this.locked) {
            this.lockedAt = this.head;
        }
        if (!this.head.used) {
            this.head.used = true;
            this.mc.adv();
        }
    }
}

