/*
 * Decompiled with CFR 0.152.
 */
package tm2;

import dialog.ColorDialog;
import dialog.SaveChangeDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Panel;
import java.awt.Point;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.StringTokenizer;
import java.util.Vector;
import mdgawt.BigCounter;
import mdgawt.EditEvent;
import mdgawt.EditableListener;
import mdgawt.FTA;
import mdgawt.MyCanvas;
import mdgawt.MyComponent;
import mdgawt.PB;
import mdgawt.Undo;
import mdgawt.WarningDialog;
import tm2.Alphabet;
import tm2.BubbleMarker;
import tm2.Ins;
import tm2.Machine;
import tm2.Marker;
import tm2.SS;
import tm2.State;
import tm2.SuperMachine;
import tm2.TMGFTA;
import tm2.TMGPUM;
import tm2.TMMB;
import tm2.Tape;

public class TMG
extends MyCanvas
implements Runnable,
ItemListener,
EditableListener {
    public static final int DFA = 0;
    public static final int NFA = 1;
    public static final int PDA = 2;
    public static final int TM = 3;
    public String[] typeNames = new String[]{"DFA", "NFA", "PDA", "TM"};
    public static String title = "Turing Kit v1.0 alpha";
    public static String defaultStartFile = "welcome.tmt";
    public static String defaultColorFile = "default.pal";
    public static boolean autoAppendText = true;
    public static boolean autoEditIns = true;
    public static boolean autoEditText = true;
    public static boolean autoEditState = true;
    public static boolean autoArrangeIns = true;
    public static boolean autoArrangeStates;
    public static boolean autoRetractText;
    public static boolean autoReduceStates;
    public static boolean wildcardsOn;
    public static boolean copysOn;
    private static boolean isRunning;
    private static int speed;
    private static Tape tape;
    private static Ins lastIns;
    private static Thread tt;
    public static PB playButton;
    private static int type;
    public static SS ss;
    private static BigCounter counter;
    private static String currentFilename;
    private static TMG topLevelGraph;
    private static char[] currentTape;
    static State currentState;
    static TMG currentMachine;
    static Ins currentIns;
    public static Font mainFont;
    public static Font instructionFont;
    public TMMB tmmb;
    public TMG parent;
    public BubbleMarker startMarker = new BubbleMarker();
    private Vector saveText;
    String gap = new String("   ");

    public TMG() {
        this(defaultStartFile);
    }

    public TMG(Machine machine) {
        this.tmmb = new TMMB(this);
        this.myFrame.setMenuBar(this.tmmb);
        currentState = null;
        currentMachine = null;
        currentIns = null;
        this.tmmb = new TMMB(this);
        this.myFrame.setMenuBar(this.tmmb);
        this.mbwm = this.tmmb;
        this.addMC(new SuperMachine("Super", 100, 100, machine));
        this.addMC(this.startMarker);
        this.minimizeCanvas();
        ((Component)this.myFrame).setLocation(100, 100);
        this.fullRepaint();
    }

    public TMG(String string) {
        ColorDialog.load(new String(defaultColorFile));
        topLevelGraph = this;
        this.setSize(300, 200);
        ss = new SS(this);
        Panel panel = new Panel();
        panel.setBackground(Color.lightGray);
        panel.setLayout(new FlowLayout(1, 6, 2));
        panel.add(ss);
        panel.add(playButton);
        panel.add(counter);
        this.myFrame.add("North", panel);
        this.myFrame.add("South", tape);
        this.setFont(new Font("Courier", 0, 14));
        this.myFrame.show();
        this.addMC(this.startMarker);
        this.editedSinceSave = false;
        this.load(string);
        this.myFrame.doLayout();
        this.minimizeCanvas();
        playButton.addItemListener(this);
    }

    public void setCurrentState(State state) {
        this.editedSinceSave = true;
        currentState = state;
        if (type == 1) {
            int n = 0;
            while ((n = this.firstInstanceOf("tm2.Marker")) >= 0) {
                this.remove(this.getComp(n));
            }
            this.addMC(new Marker("", state));
        }
        topLevelGraph.repaintAllGraphs();
    }

    public void setSize(int n, int n2) {
        int n3;
        int n4;
        if (this == topLevelGraph) {
            n4 = n + 14;
            n3 = n2 + 86 + Tape.getNumTapes() * 17;
        } else {
            n4 = n + 18;
            n3 = n2 + 54;
        }
        Dimension dimension = this.getToolkit().getScreenSize();
        n4 = Math.min(n4, dimension.width);
        n3 = Math.min(n3, dimension.height);
        ((Component)this.myFrame).setSize(n4, n3);
        this.sp.setSize(n, n2);
        super.setSize(n, n2);
        this.myFrame.validate();
    }

    public State getStartState() {
        return (State)this.startMarker.getLink(0);
    }

    public static int getType() {
        return type;
    }

    public Tape getTape() {
        return tape;
    }

    public static TMG getMainGraph() {
        return topLevelGraph;
    }

    public static int getSpeed() {
        return speed;
    }

    public String getCurrentFilename() {
        return currentFilename;
    }

    public static String getUsedAlphabet() {
        StringBuffer stringBuffer = new StringBuffer("");
        topLevelGraph.getUsedAlphabet(stringBuffer);
        boolean[] blArray = new boolean[256];
        int n = 0;
        while (n < stringBuffer.length()) {
            blArray[stringBuffer.charAt((int)n)] = true;
            ++n;
        }
        stringBuffer = new StringBuffer("");
        int n2 = 0;
        while (n2 < 256) {
            if (blArray[n2]) {
                stringBuffer.append((char)n2);
            }
            ++n2;
        }
        return new String(stringBuffer);
    }

    private void getUsedAlphabet(StringBuffer stringBuffer) {
        int n = 0;
        while (n < this.myComps.size()) {
            MyComponent myComponent = this.getComp(n);
            if (myComponent instanceof Ins) {
                int n2 = 0;
                while (n2 < Tape.getNumTapes()) {
                    stringBuffer.append(((Ins)myComponent).getRead(n2));
                    ++n2;
                }
            } else if (myComponent instanceof Machine && !(myComponent instanceof SuperMachine)) {
                ((TMG)((Machine)myComponent).getChild()).getUsedAlphabet(stringBuffer);
            }
            ++n;
        }
    }

    public SuperMachine getSuper() {
        int n = this.firstInstanceOf("tm2.SuperMachine");
        if (n < 0) {
            return null;
        }
        return (SuperMachine)this.getComp(n);
    }

    public void snapAll() {
        int n = MyCanvas.gridSize / 2;
        int n2 = 0;
        while (n2 < this.myComps.size()) {
            MyComponent myComponent = this.getComp(n2);
            if (myComponent instanceof State) {
                Point point = myComponent.getCenter();
                int n3 = (point.x + n) / MyCanvas.gridSize * MyCanvas.gridSize;
                int n4 = (point.y + n) / MyCanvas.gridSize * MyCanvas.gridSize;
                int n5 = point.x - n3;
                int n6 = point.y - n4;
                int n7 = 0;
                while (n7 < this.myComps.size()) {
                    MyComponent myComponent2 = this.getComp(n7).getLink(0);
                    if (myComponent2 != null && myComponent2 == myComponent) {
                        this.getComp(n7).translate(-n5, -n6);
                    }
                    ++n7;
                }
                myComponent.setCenter(n3, n4);
            }
            ++n2;
        }
        this.fullRepaint();
    }

    public void setCurrentFilename(String string) {
        currentFilename = string;
    }

    public void resetCounter() {
        counter.setValue(0);
        counter.repaint();
    }

    public MyComponent addMC(MyComponent myComponent) {
        super.addMC(myComponent);
        if (myComponent instanceof State && !(myComponent instanceof Machine) && this.firstInstanceOf("tm2.State") == this.lastInstanceOf("tm2.State")) {
            this.startMarker.linkTo((State)myComponent);
        }
        return myComponent;
    }

    public String askToSave() {
        SaveChangeDialog saveChangeDialog = new SaveChangeDialog(this);
        String string = saveChangeDialog.getAction();
        return string;
    }

    public void makeNew(int n) {
        Object object;
        if (this == topLevelGraph && this.editedSinceSave) {
            object = this.askToSave();
            if (((String)object).equals("Yes")) {
                this.save();
            } else if (((String)object).equals("Cancel")) {
                return;
            }
        }
        this.closeAll();
        type = n;
        if (type == 2) {
            tape.setNumTapes(2);
        } else {
            tape.setNumTapes(1);
        }
        this.resetCounter();
        currentFilename = "Untitled";
        this.myFrame.setTitle(String.valueOf(title) + "   " + this.typeNames[type] + " - " + currentFilename);
        currentState = null;
        currentMachine = null;
        currentIns = null;
        object = this.getSuper();
        this.removeAll();
        if (object != null) {
            this.addMC((MyComponent)object);
        }
        this.addMC(this.startMarker);
        this.setSize(this.getSize().width, this.getSize().height);
        this.fullRepaint();
        if (this == topLevelGraph) {
            this.editedSinceSave = false;
        }
    }

    public void load(String string) {
        String string2;
        if (this.editedSinceSave) {
            string2 = this.askToSave();
            if (string2.equals("Yes")) {
                this.save();
            } else if (string2.equals("Cancel")) {
                return;
            }
        }
        this.resetCounter();
        currentState = null;
        currentMachine = null;
        currentIns = null;
        if (this == topLevelGraph) {
            currentFilename = new String(string);
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            string2 = bufferedReader.readLine();
            if (string2.equals("Version=1.1")) {
                bufferedReader.close();
                this.readSetup(string);
                this.loadMachine11(string, "Machine");
            } else {
                System.out.println("File format not supported");
            }
            if (this == topLevelGraph) {
                this.setCurrentState((State)this.startMarker.getLink(0));
            }
            this.repaint();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        this.myFrame.setTitle(String.valueOf(title) + "   " + this.typeNames[type] + " - " + currentFilename);
        this.editedSinceSave = false;
    }

    public void readText(String string, String string2) {
        String string3 = "x";
        this.saveText = new Vector(4, 4);
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while (!(string3 = bufferedReader.readLine()).startsWith(String.valueOf(string2) + ":Text")) {
            }
            new String("End" + string2 + ":Text");
            while ((string3 = bufferedReader.readLine()) != null) {
                if (string3.startsWith("End")) break;
                if (!string3.startsWith("Text") || string3.startsWith("Textbox")) continue;
                String string4 = new String(String.valueOf(string3.substring(4, string3.indexOf(61))));
                int n = 0;
                do {
                    String string5 = bufferedReader.readLine();
                    if (n != 0) {
                        string4 = string4.concat("\n");
                    }
                    string4 = string4.concat(string5);
                    ++n;
                } while (!string4.endsWith("EndText"));
                string4 = string4.substring(0, string4.length() - 8);
                this.saveText.addElement(string4);
            }
            bufferedReader.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
    }

    public void loadMachine11(String string, String string2) {
        if (MyCanvas.debug) {
            System.out.println("loading " + string2);
        }
        this.readText(string, string2);
        this.removeAll();
        try {
            String string3;
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while (!(string3 = bufferedReader.readLine()).startsWith("Start" + string2)) {
            }
            while ((string3 = bufferedReader.readLine()) != null) {
                MyComponent myComponent;
                String string4;
                StringTokenizer stringTokenizer;
                MyComponent myComponent2;
                string3 = string3.trim();
                if (MyCanvas.debug) {
                    System.out.println(string3);
                }
                if (string3.startsWith("End")) break;
                if (string3.startsWith("State")) {
                    if (MyCanvas.debug) {
                        System.out.println("loading state");
                    }
                    myComponent2 = new State("", 0, 0, false);
                    stringTokenizer = new StringTokenizer(string3.substring(string3.indexOf(61) + 1), ",");
                    myComponent2.saveName = string3.substring(0, string3.indexOf(61));
                    if (string3.charAt(5) == '\u0000') {
                        this.startMarker.linkTo((State)myComponent2);
                    }
                    while (stringTokenizer.hasMoreTokens()) {
                        String string5 = stringTokenizer.nextToken();
                        if (MyCanvas.debug) {
                            System.out.println("next token = " + string5);
                        }
                        if (string5.equals("accepting")) {
                            ((State)myComponent2).setAccepting(true);
                            continue;
                        }
                        if (string5.equals("rejecting")) {
                            ((State)myComponent2).setAccepting(false);
                            continue;
                        }
                        if (string5.startsWith("x")) {
                            myComponent2.setLocation(Integer.parseInt(string5.substring(1)), myComponent2.getLocation().y);
                            continue;
                        }
                        if (string5.startsWith("y")) {
                            myComponent2.setLocation(myComponent2.getLocation().x, Integer.parseInt(string5.substring(1)));
                            continue;
                        }
                        if (!string5.startsWith("Text")) continue;
                        myComponent2.setText(this.getSaveText(string5.substring(4)));
                    }
                    this.addMC(myComponent2);
                    continue;
                }
                if (string3.startsWith("Machine")) {
                    if (MyCanvas.debug) {
                        System.out.println("loading Machine");
                    }
                    myComponent2 = new Machine("", 0, 0);
                    stringTokenizer = new StringTokenizer(string3.substring(string3.indexOf(61) + 1), ",");
                    myComponent2.saveName = string3.substring(0, string3.indexOf(61));
                    myComponent2.savePath = new String(String.valueOf(string2) + "->" + string3.trim().substring(7, string3.indexOf(61)));
                    while (stringTokenizer.hasMoreTokens()) {
                        String string6 = stringTokenizer.nextToken();
                        if (MyCanvas.debug) {
                            System.out.println("next token = " + string6);
                        }
                        if (string6.equals("accepting")) {
                            ((State)myComponent2).setAccepting(true);
                            continue;
                        }
                        if (string6.equals("rejecting")) {
                            ((State)myComponent2).setAccepting(false);
                            continue;
                        }
                        if (string6.startsWith("x")) {
                            myComponent2.setLocation(Integer.parseInt(string6.substring(1)), myComponent2.getLocation().y);
                            continue;
                        }
                        if (string6.startsWith("y")) {
                            myComponent2.setLocation(myComponent2.getLocation().x, Integer.parseInt(string6.substring(1)));
                            continue;
                        }
                        if (!string6.startsWith("Text")) continue;
                        myComponent2.setText(this.getSaveText(string6.substring(4)));
                    }
                    this.addMCNF(myComponent2);
                    ((TMG)myComponent2.getChild()).loadMachine11(string, myComponent2.savePath);
                    continue;
                }
                if (string3.startsWith("Super")) {
                    if (MyCanvas.debug) {
                        System.out.println("loading Super");
                    }
                    myComponent2 = this.getSuper();
                    stringTokenizer = new StringTokenizer(string3.substring(string3.indexOf(61) + 1), ",");
                    myComponent2.saveName = string3.substring(0, string3.indexOf(61));
                    while (stringTokenizer.hasMoreTokens()) {
                        String string7 = stringTokenizer.nextToken();
                        if (MyCanvas.debug) {
                            System.out.println("next token = " + string7);
                        }
                        if (string7.startsWith("x")) {
                            myComponent2.setLocation(Integer.parseInt(string7.substring(1)), myComponent2.getLocation().y);
                            continue;
                        }
                        if (string7.startsWith("y")) {
                            myComponent2.setLocation(myComponent2.getLocation().x, Integer.parseInt(string7.substring(1)));
                            continue;
                        }
                        if (!string7.startsWith("Text")) continue;
                        myComponent2.setText(this.getSaveText(string7.substring(4)));
                    }
                    continue;
                }
                if (string3.startsWith("Instruction")) {
                    stringTokenizer = new StringTokenizer(string3.substring(string3.indexOf(61) + 1), ",");
                    myComponent2 = (State)this.getSaveName(stringTokenizer.nextToken());
                    String string8 = stringTokenizer.nextToken();
                    String string9 = stringTokenizer.nextToken();
                    string4 = stringTokenizer.nextToken();
                    myComponent = (State)this.getSaveName(stringTokenizer.nextToken());
                    Ins ins = new Ins((State)myComponent2, string8, string9, string4, (State)myComponent, 0, 0);
                    ins.saveName = string3.substring(0, string3.indexOf(61));
                    while (stringTokenizer.hasMoreTokens()) {
                        String string10 = stringTokenizer.nextToken();
                        if (string10.startsWith("x")) {
                            ins.setLocation(Integer.parseInt(string10.substring(1)), ins.getLocation().y);
                            continue;
                        }
                        if (string10.startsWith("y")) {
                            ins.setLocation(ins.getLocation().x, Integer.parseInt(string10.substring(1)));
                            continue;
                        }
                        if (string10.equals("Line")) {
                            ins.setArcType(1);
                            continue;
                        }
                        if (string10.equals("Bezier")) {
                            ins.setArcType(2);
                            continue;
                        }
                        if (!string10.equals("Hermite")) continue;
                        ins.setArcType(3);
                    }
                    this.addMCNF(ins);
                    continue;
                }
                if (!string3.startsWith("Textbox")) continue;
                stringTokenizer = new StringTokenizer(string3.substring(string3.indexOf(61) + 1), ",");
                myComponent2 = new TMGFTA("", 0, 0, this.getGraphics());
                myComponent2.saveName = string3.substring(0, string3.indexOf(61));
                boolean bl = false;
                boolean bl2 = false;
                while (stringTokenizer.hasMoreTokens()) {
                    string4 = stringTokenizer.nextToken();
                    if (string4.startsWith("x")) {
                        myComponent2.setLocation(Integer.parseInt(string4.substring(1)), myComponent2.getLocation().y);
                        continue;
                    }
                    if (string4.startsWith("y")) {
                        myComponent2.setLocation(myComponent2.getLocation().x, Integer.parseInt(string4.substring(1)));
                        continue;
                    }
                    if (string4.startsWith("Text")) {
                        ((FTA)myComponent2).setText(this.getSaveText(string4.substring(4)));
                        bl = true;
                        continue;
                    }
                    myComponent = this.getSaveName(string4);
                    if (myComponent == null) continue;
                    if (MyCanvas.debug) {
                        System.out.println("Linking to " + myComponent.saveName);
                    }
                    ((FTA)myComponent2).addLink(myComponent);
                    bl2 = true;
                }
                if (bl2 && !bl) {
                    ((FTA)myComponent2).bind();
                    if (MyCanvas.debug) {
                        System.out.println("binding");
                    }
                }
                this.addMCNF(myComponent2);
            }
            this.fixData();
            this.fullRepaint();
            this.tmmb = new TMMB(this);
            this.myFrame.setMenuBar(this.tmmb);
            this.mbwm = this.tmmb;
            this.minimizeCanvas();
            this.fullRepaint();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        if (MyCanvas.debug) {
            System.out.println("end load 11");
        }
    }

    public MyComponent getSaveName(String string) {
        if (MyCanvas.debug) {
            System.out.println("getSaveName(" + string + ")");
        }
        if (MyCanvas.debug) {
            System.out.println("###=" + this.myComps.size());
        }
        int n = 0;
        while (n < this.myComps.size()) {
            String string2 = this.getComp((int)n).saveName;
            if (string2 == null) {
                System.out.println("temp was null");
            }
            if (this.getComp((int)n).saveName.equals(string)) {
                return this.getComp(n);
            }
            ++n;
        }
        System.out.println(String.valueOf(string) + " not found");
        return null;
    }

    public String getSaveText(String string) {
        if (MyCanvas.debug) {
            System.out.println("search index = " + string);
        }
        int n = 0;
        while (n < this.saveText.size()) {
            String string2 = (String)this.saveText.elementAt(n);
            if (MyCanvas.debug) {
                System.out.println("looking at =" + string2);
            }
            if (string2.startsWith(string)) {
                return string2.substring(string.length());
            }
            ++n;
        }
        return null;
    }

    public void readSetup(String string) {
        if (MyCanvas.debug) {
            System.out.println("start read setup");
        }
        try {
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new FileInputStream(string)));
            while (true) {
                String string2;
                if ((string2 = bufferedReader.readLine()) != null) {
                    string2 = string2.trim();
                }
                if (string2 == null) break;
                if (string2.equals("AutoAppendText=true")) {
                    autoAppendText = true;
                    continue;
                }
                if (string2.equals("AutoAppendText=false")) {
                    autoAppendText = false;
                    continue;
                }
                if (string2.equals("AutoEditIns=true")) {
                    autoEditIns = true;
                    continue;
                }
                if (string2.equals("AutoEditIns=false")) {
                    autoEditIns = false;
                    continue;
                }
                if (string2.equals("AutoEditText=true")) {
                    autoEditText = true;
                    continue;
                }
                if (string2.equals("AutoEditText=false")) {
                    autoEditText = false;
                    continue;
                }
                if (string2.equals("AutoEditState=true")) {
                    autoEditState = true;
                    continue;
                }
                if (string2.equals("AutoEditState=false")) {
                    autoEditState = false;
                    continue;
                }
                if (string2.equals("AutoArrangeIns=true")) {
                    autoArrangeIns = true;
                    continue;
                }
                if (string2.equals("AutoArrangeIns=false")) {
                    autoArrangeIns = false;
                    continue;
                }
                if (string2.equals("AutoArrangeStates=true")) {
                    autoArrangeStates = true;
                    continue;
                }
                if (string2.equals("AutoArrangeStates=false")) {
                    autoArrangeStates = false;
                    continue;
                }
                if (string2.equals("AutoRetractText=true")) {
                    autoRetractText = true;
                    continue;
                }
                if (string2.equals("AutoRetractText=false")) {
                    autoRetractText = false;
                    continue;
                }
                if (string2.equals("AutoReduceStates=true")) {
                    autoReduceStates = true;
                    continue;
                }
                if (string2.equals("AutoReduceStates=false")) {
                    autoReduceStates = false;
                    continue;
                }
                if (string2.equals("WildcardsOn=true")) {
                    wildcardsOn = true;
                    continue;
                }
                if (string2.equals("WildcardsOn=false")) {
                    wildcardsOn = false;
                    continue;
                }
                if (string2.equals("BoxesOn=true")) {
                    FTA.boxesOn = true;
                    continue;
                }
                if (string2.equals("BoxesOn=false")) {
                    FTA.boxesOn = false;
                    continue;
                }
                if (string2.equals("StateNamesOn=true")) {
                    TMGFTA.stateNamesOn = true;
                    continue;
                }
                if (string2.equals("StateNamesOn=false")) {
                    TMGFTA.stateNamesOn = false;
                    continue;
                }
                if (string2.equals("StateTextOn=true")) {
                    TMGFTA.stateTextOn = true;
                    continue;
                }
                if (string2.equals("StateTextOn=false")) {
                    TMGFTA.stateTextOn = false;
                    continue;
                }
                if (string2.equals("InstructionNamesOn=true")) {
                    TMGFTA.instructionNamesOn = true;
                    continue;
                }
                if (string2.equals("InstructionNamesOn=false")) {
                    TMGFTA.instructionNamesOn = false;
                    continue;
                }
                if (string2.equals("InstructionTextOn=true")) {
                    TMGFTA.instructionTextOn = true;
                    continue;
                }
                if (string2.equals("InstructionTextOn=false")) {
                    TMGFTA.instructionTextOn = false;
                    continue;
                }
                if (string2.equals("FreeTextOn=true")) {
                    TMGFTA.freeTextOn = true;
                    continue;
                }
                if (string2.equals("FreeTextOn=false")) {
                    TMGFTA.freeTextOn = false;
                    continue;
                }
                if (string2.equals("GridOn=true")) {
                    MyCanvas.gridOn = true;
                    continue;
                }
                if (string2.equals("GridOn=false")) {
                    MyCanvas.gridOn = false;
                    continue;
                }
                if (string2.equals("DefaultArcType=line")) {
                    MyComponent.defaultType = 1;
                    continue;
                }
                if (string2.equals("DefaultArcType=parabolic")) {
                    MyComponent.defaultType = 2;
                    continue;
                }
                if (string2.equals("DefaultArcType=quadratic")) {
                    MyComponent.defaultType = 3;
                    continue;
                }
                if (string2.equals("DefaultArcType=boxed")) {
                    MyComponent.defaultType = 4;
                    continue;
                }
                if (string2.startsWith("InstructionGap")) {
                    Ins.gap = Integer.parseInt(string2.substring(15));
                    continue;
                }
                if (string2.equals("Type=DFA")) {
                    type = 0;
                    continue;
                }
                if (string2.equals("Type=NFA")) {
                    type = 1;
                    continue;
                }
                if (string2.equals("Type=PFA")) {
                    type = 2;
                    continue;
                }
                if (string2.equals("Type=TM")) {
                    type = 3;
                    continue;
                }
                if (string2.startsWith("NumberOfTapes")) {
                    tape.setNumTapes(Integer.parseInt(string2.substring(14)));
                    continue;
                }
                if (string2.startsWith("AlphabetMin")) {
                    Alphabet.setMin(Integer.parseInt(string2.substring(12)));
                    continue;
                }
                if (string2.startsWith("AlphabetMax")) {
                    Alphabet.setMax(Integer.parseInt(string2.substring(12)));
                    continue;
                }
                if (string2.startsWith("Alphabet")) {
                    Ins.alphabet.setAlphabet(string2.substring(9, string2.length() - 5));
                    continue;
                }
                if (string2.startsWith("Blank")) {
                    Alphabet.blank = string2.charAt(6);
                    continue;
                }
                if (string2.startsWith("Wildcards")) {
                    Ins.alphabet.setWildcards(string2.substring(10, string2.length() - 5));
                    continue;
                }
                if (string2.equals("MainMachine")) break;
            }
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
        if (MyCanvas.debug) {
            System.out.println("end read setup");
        }
    }

    public void save() {
        this.save(currentFilename);
    }

    public void save(String string) {
        this.setCurrentFilename(string);
        this.myFrame.setTitle(String.valueOf(title) + "   " + this.typeNames[type] + " - " + string);
        try {
            PrintWriter printWriter = new PrintWriter(new FileOutputStream(string));
            printWriter.println("Version=1.1");
            printWriter.println("AutoAppendText=" + autoAppendText);
            printWriter.println("AutoEditIns=" + autoEditIns);
            printWriter.println("AutoEditText=" + autoEditText);
            printWriter.println("AutoEditState=" + autoEditState);
            printWriter.println("AutoArrangeIns=" + autoArrangeIns);
            printWriter.println("AutoArrangeStates=" + autoArrangeStates);
            printWriter.println("AutoRetractText=" + autoRetractText);
            printWriter.println("AutoReduceStates=" + autoReduceStates);
            printWriter.println("WildcardsOn=" + wildcardsOn);
            printWriter.println("BoxesOn=" + FTA.boxesOn);
            printWriter.println("StateNamesOn=" + TMGFTA.stateNamesOn);
            printWriter.println("StateTextOn=" + TMGFTA.stateTextOn);
            printWriter.println("InstructionNamesOn=" + TMGFTA.instructionNamesOn);
            printWriter.println("InstructionTextOn=" + TMGFTA.instructionTextOn);
            printWriter.println("FreeTextOn=" + TMGFTA.freeTextOn);
            printWriter.println("GridOn=" + MyCanvas.gridOn);
            printWriter.println("DefaultArcType=" + MyComponent.defaultType);
            printWriter.println("InstructionGap=" + Ins.gap);
            printWriter.println("Type=" + this.typeNames[type]);
            printWriter.println("NumberOfTapes=" + Tape.getNumTapes());
            printWriter.println("AlphabetMin=" + Alphabet.getMin());
            printWriter.println("AlphabetMax=" + Alphabet.getMax());
            printWriter.println("Alphabet=" + Ins.alphabet.toString() + "<$$$>");
            printWriter.println("Blank=" + Alphabet.blank + "<$$$>");
            printWriter.println("Wildcards=" + Ins.alphabet.getWildcards() + "<$$$>");
            printWriter.println("");
            this.saveMachine(printWriter, "Machine");
            printWriter.close();
            this.editedSinceSave = false;
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
    }

    public void saveMachine(PrintWriter printWriter, String string) {
        Object object;
        Object object2;
        Object object3;
        Serializable serializable;
        Serializable serializable2;
        Point point;
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        this.saveText = new Vector(4, 4);
        State state = (State)this.startMarker.getLink(0);
        SuperMachine superMachine = this.getSuper();
        printWriter.println("Start" + string);
        if (superMachine != null) {
            point = superMachine.getLocation();
            superMachine.saveName = new String("Super");
            printWriter.println(String.valueOf(this.gap) + superMachine.saveName + "=" + "x" + point.x + "," + "y" + point.y + "," + "Text" + this.saveText.size());
            this.saveText.addElement(superMachine.getText());
        }
        if (state != null) {
            point = state.getLocation();
            state.saveName = new String("State0");
            printWriter.println(String.valueOf(this.gap) + state.saveName + "=" + state.getAcceptingString() + "," + "x" + point.x + "," + "y" + point.y + "," + "Text" + this.saveText.size());
            this.saveText.addElement(state.getText());
            ++n;
        }
        if (MyCanvas.debug) {
            System.out.println("SavingStates");
        }
        int n5 = 0;
        while (n5 < this.myComps.size()) {
            MyComponent myComponent = this.getComp(n5);
            serializable2 = myComponent.getLocation();
            if (myComponent instanceof State && myComponent != state && !(myComponent instanceof Machine) && !(myComponent instanceof SuperMachine)) {
                serializable = (State)myComponent;
                ((MyComponent)serializable).saveName = new String("State" + n);
                object3 = new String(String.valueOf(this.gap) + ((MyComponent)serializable).saveName + "=" + ((State)serializable).getAcceptingString() + "," + "x" + ((Point)serializable2).x + "," + "y" + ((Point)serializable2).y);
                if (!((MyComponent)serializable).getText().trim().equals("")) {
                    object3 = ((String)object3).concat(",Text" + this.saveText.size());
                    this.saveText.addElement(((MyComponent)serializable).getText());
                }
                printWriter.println((String)object3);
                ++n;
            }
            ++n5;
        }
        if (MyCanvas.debug) {
            System.out.println("SavingMachines");
        }
        int n6 = 0;
        while (n6 < this.myComps.size()) {
            serializable2 = this.getComp(n6);
            serializable = ((MyComponent)serializable2).getLocation();
            if (serializable2 instanceof Machine && serializable2 != state && !(serializable2 instanceof SuperMachine)) {
                object3 = (Machine)serializable2;
                ((MyComponent)object3).saveName = new String("Machine" + n4);
                ((MyComponent)object3).savePath = new String(String.valueOf(string) + "->" + n4);
                object2 = new String(String.valueOf(this.gap) + "Machine" + n4 + "=" + "x" + ((Point)serializable).x + "," + "y" + ((Point)serializable).y);
                if (!((MyComponent)object3).getText().trim().equals("")) {
                    object2 = ((String)object2).concat(",Text" + this.saveText.size());
                    this.saveText.addElement(((MyComponent)object3).getText());
                }
                printWriter.println((String)object2);
                ++n4;
            }
            ++n6;
        }
        if (MyCanvas.debug) {
            System.out.println("SavingInstructions");
        }
        int n7 = 0;
        while (n7 < this.myComps.size()) {
            serializable = this.getComp(n7);
            object3 = ((MyComponent)serializable).getLocation();
            if (serializable instanceof Ins) {
                object2 = (Ins)serializable;
                ((MyComponent)object2).saveName = new String("Instruction" + n2);
                printWriter.println(String.valueOf(this.gap) + ((MyComponent)object2).saveName + "=" + ((Ins)object2).getFrom().saveName + "," + ((Ins)object2).getRead() + "," + ((Ins)object2).getWrite() + "," + ((Ins)object2).getDir() + "," + ((Ins)object2).getTo().saveName + "," + "x" + ((Point)object3).x + "," + "y" + ((Point)object3).y + "," + ((MyComponent)object2).getArcName());
                ++n2;
            }
            ++n7;
        }
        if (MyCanvas.debug) {
            System.out.println("SavingTextboxes");
        }
        int n8 = 0;
        while (n8 < this.myComps.size()) {
            object3 = this.getComp(n8);
            object2 = ((MyComponent)object3).getLocation();
            if (object3 instanceof FTA) {
                FTA fTA = (FTA)object3;
                fTA.saveName = new String("Textbox" + n3);
                object = new String(String.valueOf(fTA.saveName) + "=" + "x" + ((Point)object2).x + "," + "y" + ((Point)object2).y);
                int n9 = 0;
                while (n9 < fTA.links.size()) {
                    object = ((String)object).concat("," + fTA.getLink((int)n9).saveName);
                    ++n9;
                }
                if (fTA.getType() != 2) {
                    object = ((String)object).concat(",Text" + this.saveText.size());
                    this.saveText.addElement(fTA.getText());
                }
                printWriter.println(String.valueOf(this.gap) + (String)object);
                ++n3;
            }
            ++n8;
        }
        printWriter.println("End" + string);
        printWriter.println("");
        printWriter.println(String.valueOf(string) + ":Text");
        if (MyCanvas.debug) {
            System.out.println("SavingText");
        }
        int n10 = 0;
        while (n10 < this.saveText.size()) {
            printWriter.println("Text" + n10 + "=");
            object3 = new StringTokenizer((String)this.saveText.elementAt(n10), "\n");
            while (((StringTokenizer)object3).hasMoreTokens()) {
                printWriter.println(((StringTokenizer)object3).nextToken());
            }
            printWriter.println("EndText");
            ++n10;
        }
        printWriter.println("End" + string + ":Text");
        printWriter.println("");
        int n11 = 0;
        while (n11 < this.myComps.size()) {
            object = this.getComp(n11);
            ((MyComponent)object).getLocation();
            if (object instanceof Machine && object != state && !(object instanceof SuperMachine)) {
                Machine machine = (Machine)object;
                ((TMG)machine.getChild()).saveMachine(printWriter, machine.savePath);
            }
            ++n11;
        }
    }

    public void organize() {
        this.editedSinceSave = true;
        if (autoArrangeIns) {
            this.arrangeIns();
            this.retractInsText();
        }
        if (autoRetractText) {
            this.retractAllText();
        }
        this.fullRepaint();
    }

    public int countStates() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.myComps.size()) {
            if (this.getComp(n2) instanceof State) {
                ((State)this.getComp((int)n2)).index = n++;
            }
            ++n2;
        }
        return n;
    }

    public void reduceStates() {
    }

    public void show(int n, int[][] nArray) {
        int n2;
        StringBuffer stringBuffer;
        int n3 = 0;
        while (n3 < n) {
            stringBuffer = new StringBuffer(" " + n3 + "  ");
            n2 = 0;
            while (n2 < n) {
                stringBuffer.append("  " + nArray[n3][n2]);
                ++n2;
            }
            System.out.println(stringBuffer.toString());
            ++n3;
        }
        System.out.println("");
        stringBuffer = new StringBuffer("    ");
        n2 = 0;
        while (n2 < n) {
            stringBuffer.append("  " + n2);
            ++n2;
        }
        System.out.println(stringBuffer.toString());
    }

    public void combine(State state, State state2) {
        int n = this.firstInstanceOf("tm2.Ins");
        int n2 = this.lastInstanceOf("tm2.Ins");
        int n3 = n;
        while (n3 <= n2) {
            if (this.getComp(n3).getLink(1) == state2) {
                ((Ins)this.getComp(n3)).linkTo(state);
                this.remove(state2, new Undo(""));
            }
            ++n3;
        }
    }

    public void arrangeIns() {
        float f = 0.0f;
        int n = Ins.gap;
        State state = null;
        State state2 = null;
        int n2 = this.firstInstanceOf("tm2.Ins");
        int n3 = this.lastInstanceOf("tm2.Ins");
        int n4 = n2;
        while (n4 <= n3) {
            Ins ins;
            int n5;
            int n6;
            Ins ins2 = (Ins)this.getComp(n4);
            State state3 = ins2.getFrom();
            State state4 = ins2.getTo();
            if (state3 == state && state4 == state2) {
                f += (float)n;
            } else {
                n6 = 0;
                n5 = n2;
                while (n5 <= n3) {
                    ins = (Ins)this.getComp(n5);
                    if (ins.getFrom() == state3 && ins.getTo() == state4 || ins.getFrom() == state4 && ins.getTo() == state3) {
                        ++n6;
                    }
                    ++n5;
                }
                f = n6 == 1 ? 0.0f : (float)n;
                state = state3;
                state2 = state4;
            }
            if (state4 == state3) {
                n6 = 0;
                n5 = n2;
                while (n5 <= n3) {
                    ins = (Ins)this.getComp(n5);
                    if (ins.getFrom() == state3 && ins.getTo() == state3) {
                        ++n6;
                    }
                    ++n5;
                }
                int n7 = state4.getCenter().x;
                int n8 = state4.getCenter().y;
                double d = (double)(f / (float)n6 / (float)n) * 360.0 * Math.PI / 180.0;
                ins2.setLocation((int)(-50.0 * Math.sin(d)) + n7 - ins2.getSize().width / 2, (int)(50.0 * Math.cos(d)) + n8 - ins2.getSize().height / 2);
            } else {
                float f2;
                Point point = state3.getCenter();
                Point point2 = state4.getCenter();
                float f3 = point.x;
                float f4 = point.y;
                float f5 = point2.x;
                float f6 = point2.y;
                float f7 = f;
                if (f6 < f4) {
                    float f8 = f6;
                    f6 = f4;
                    f4 = f8;
                    f8 = f5;
                    f5 = f3;
                    f3 = f8;
                    f7 = -f7;
                }
                if ((f2 = (float)Math.sqrt((f6 - f4) * (f6 - f4) + (f5 - f3) * (f5 - f3))) < 10.0f) {
                    ins2.setLocation((int)f3, (int)f4);
                } else {
                    float f9 = (float)((double)f2 / 2.0);
                    float f10 = (float)Math.acos((f5 - f3) / f2);
                    float f11 = (float)Math.cos(f10);
                    float f12 = (float)Math.sin(f10);
                    ins2.setLocation((int)(f9 * f11 - f7 * f12 + f3), (int)(f9 * f12 + f7 * f11 + f4));
                }
            }
            ++n4;
        }
    }

    public void retractAllText() {
        int n = this.firstInstanceOf("tm2.TMGFTA");
        int n2 = this.lastInstanceOf("tm2.TMGFTA");
        int n3 = n;
        while (n3 <= n2) {
            TMGFTA tMGFTA = (TMGFTA)this.getComp(n3);
            if (tMGFTA.getLink() != null) {
                boolean bl = false;
                int n4 = 0;
                while (!bl) {
                    int n5 = 0;
                    while (n5 < 4) {
                        tMGFTA.retract(n5, n4);
                        if (!this.intersects(tMGFTA)) {
                            bl = true;
                            n5 = 4;
                        }
                        ++n5;
                    }
                    ++n4;
                }
            }
            ++n3;
        }
    }

    public void retractInsText() {
    }

    public void paste(int n, int n2) {
        this.editedSinceSave = true;
        new Undo("Paste");
        Vector vector = MyCanvas.copied;
        new Vector(4, 4);
        new Vector(4, 4);
        ((MyComponent)vector.elementAt(0)).getLocation();
    }

    protected void fixData() {
        MyComponent myComponent;
        int n;
        if (MyCanvas.debug) {
            System.out.println("in TMG:fixData");
        }
        if (this.startMarker.getLink(0) == null) {
            this.startMarker.grabClosest();
        }
        this.sortByClass();
        int n2 = this.firstInstanceOf("tm2.Ins");
        int n3 = this.lastInstanceOf("tm2.Ins");
        this.sortByLinkText(n2, n3, 1);
        this.sortByLinkText(n2, n3, 0);
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.myComps.size()) {
            n = 0;
            if (this.getComp(n5) instanceof State || this.getComp(n5) instanceof Machine || this.getComp(n5) instanceof SuperMachine) {
                myComponent = (State)this.getComp(n5);
                ((State)myComponent).index = n4++;
                ((State)myComponent).start = -1;
                ((State)myComponent).end = -2;
                int n6 = n2;
                while (n6 <= n3) {
                    if (this.getComp((int)n6).links.size() > 0 && (State)((Ins)this.getComp(n6)).getLink(0) == myComponent) {
                        if (n == 0) {
                            ((State)myComponent).start = ((State)myComponent).end = n6;
                            n = 1;
                        } else {
                            ((State)myComponent).end = n6;
                        }
                    }
                    ++n6;
                }
            }
            ++n5;
        }
        if (MyCanvas.debug) {
            n = 0;
            while (n < this.myComps.size()) {
                if (this.getComp(n) instanceof State || this.getComp(n) instanceof Machine || this.getComp(n) instanceof SuperMachine) {
                    myComponent = (State)this.getComp(n);
                    if (MyCanvas.debug) {
                        System.out.println("State " + ((State)myComponent).index + " goes from " + ((State)myComponent).start + " to " + ((State)myComponent).end);
                    }
                }
                ++n;
            }
        }
        if (MyCanvas.debug) {
            n = n2;
            while (n <= n3) {
                myComponent = (Ins)this.getComp(n);
                if (MyCanvas.debug) {
                    System.out.println(String.valueOf(myComponent.toString()) + "   From " + ((State)myComponent.getLink((int)0)).index + "  to  " + ((State)myComponent.getLink((int)1)).index);
                }
                ++n;
            }
        }
    }

    public void repaintEverything() {
        this.repaintAllGraphs();
        tape.update();
        counter.repaint();
    }

    public void paintMove() {
        Graphics graphics = currentMachine.getGraphics();
        if (graphics == null) {
            return;
        }
        Point point = this.sp.getScrollPosition();
        Dimension dimension = this.sp.getViewportSize();
        ((Component)TMG.currentMachine.myFrame).setVisible(true);
        TMG.currentMachine.myFrame.show();
        if (lastIns != null) {
            lastIns.paint(lastIns.getOwner().getGraphics());
        }
        if (currentIns != null) {
            this.hasBeenEdited = true;
            currentIns.paint(graphics);
            currentIns.getLink(0).paint(graphics);
            Point point2 = currentIns.getLink(1).getLocation();
            if (point2.x < point.x || point2.y < point.y || point2.x > point.x + dimension.width || point2.y > point.y + dimension.height) {
                this.sp.setScrollPosition(point2.x - dimension.width / 2, point2.y - dimension.height / 2);
            }
            currentIns.getLink(1).paint(graphics);
        }
    }

    public void setSpeed(int n) {
        speed = n;
        if (speed == 0) {
            isRunning = false;
            if (playButton.getState() == 1) {
                playButton.setState(2);
            }
        }
    }

    public void start() {
        if (MyCanvas.debug && currentState == null) {
            System.out.println("current state = null");
        }
        if (isRunning || currentState == null) {
            return;
        }
        currentMachine = (TMG)currentState.getOwner();
        if (speed == 0) {
            this.step();
            if (type == 1) {
                this.fullRepaint();
            } else if (currentIns != null) {
                currentMachine.paintMove();
            }
            tape.update();
            counter.repaint();
            playButton.setState(2);
            return;
        }
        tt = new Thread(this);
        tt.start();
    }

    private void stop() {
        isRunning = false;
        if (playButton.getState() == 1) {
            playButton.setState(2);
        }
    }

    public void run() {
        isRunning = true;
        while (isRunning) {
            this.step();
            if (currentIns == null && type != 1) {
                return;
            }
            if (speed == 13) {
                if (counter.getValue() % 10000 != 0) continue;
                tape.update();
                counter.paint(counter.getGraphics());
                continue;
            }
            if (speed == 12) {
                if (counter.getValue() % 1000 != 0) continue;
                tape.update();
                counter.paint(counter.getGraphics());
                continue;
            }
            if (speed == 11) {
                if (counter.getValue() % 100 != 0) continue;
                tape.update();
                counter.paint(counter.getGraphics());
                continue;
            }
            if (speed >= 11) continue;
            if (type == 1) {
                this.fullRepaint();
            } else {
                currentMachine.paintMove();
            }
            tape.update();
            counter.paint(counter.getGraphics());
            try {
                Thread.sleep(1000 - Math.min(speed * 100, 1000));
            }
            catch (InterruptedException interruptedException) {}
        }
        this.repaintEverything();
    }

    public synchronized void step() {
        if (type == 1) {
            this.stepNFA();
            return;
        }
        currentTape = tape.read();
        lastIns = currentIns;
        currentIns = this.findPath();
        if (currentIns == null) {
            String string = currentState.getAccepting() ? new String("String accepted.") : new String("String not accepted.");
            new WarningDialog(this.myFrame, "Halt", string);
            return;
        }
        ++TMG.currentIns.count;
        if (type == 3 || type == 2) {
            Tape.getNumTapes();
            if (wildcardsOn) {
                int n = Tape.getNumTapes();
                char[] cArray = new char[n];
                int n2 = 0;
                while (n2 < n) {
                    cArray[n2] = currentIns.getRead(n2) == Alphabet.wildcard && currentIns.getWrite(n2) == Alphabet.wildcard ? currentTape[n2] : currentIns.getWrite(n2);
                    ++n2;
                }
                tape.write(cArray);
            } else {
                tape.write(currentIns);
            }
        }
        tape.move(currentIns);
        currentState = (State)currentIns.getLink(1);
        if (MyCanvas.debug) {
            System.out.println("Steped into " + TMG.currentState.index);
        }
        counter.adv();
    }

    public Vector getMarkers() {
        Vector<MyComponent> vector = new Vector<MyComponent>();
        int n = 0;
        while (n < this.myComps.size()) {
            if (this.getComp(n) instanceof Marker) {
                vector.addElement(this.getComp(n));
            }
            ++n;
        }
        return vector;
    }

    public synchronized void stepNFA() {
        currentTape = tape.read();
        int n = this.findPathsNFA();
        if (n == 0) {
            String string = currentState.getAccepting() ? new String("String accepted.") : new String("String not accepted.");
            new WarningDialog(this.myFrame, "Halt", string);
            isRunning = false;
            if (playButton.getState() == 1) {
                playButton.setState(2);
            }
            return;
        }
        tape.move(82);
        counter.adv();
    }

    private int findPathsNFA() {
        Vector vector = this.getMarkers();
        int n = 0;
        int n2 = 0;
        while (n2 < vector.size()) {
            Marker marker = (Marker)vector.elementAt(n2);
            if (marker.isAlive()) {
                ++n;
                currentState = marker.getState();
                if (currentState instanceof SuperMachine) {
                    currentState = ((SuperMachine)TMG.currentState).linkBack;
                } else if (currentState instanceof Machine) {
                    currentState = ((TMG)((Machine)currentState).getChild()).getSuper();
                }
                currentMachine = (TMG)currentState.getOwner();
                int n3 = 0;
                int n4 = TMG.currentState.start;
                while (n4 <= TMG.currentState.end) {
                    int n5 = 0;
                    int n6 = Tape.getNumTapes();
                    Ins ins = (Ins)currentMachine.getComp(n4);
                    int n7 = 0;
                    while (n7 < n6) {
                        if (ins.getRead(n7) == currentTape[n7] || ins.getRead(n7) == Alphabet.lambda) {
                            ++n5;
                        }
                        ++n7;
                    }
                    if (n5 == n6) {
                        if (n3 > 0) {
                            this.addMC(new Marker(marker.getHistory(), ins.getTo()));
                        } else {
                            marker.setState(ins);
                        }
                        ++n3;
                    }
                    ++n4;
                }
                if (n3 == 0) {
                    marker.kill();
                }
            }
            ++n2;
        }
        return n;
    }

    private Ins findPath() {
        int n;
        Ins ins;
        int n2;
        int n3;
        if (currentState == null) {
            return null;
        }
        if (currentState instanceof SuperMachine) {
            if (MyCanvas.debug) {
                System.out.println("in SuperMachine");
            }
            currentState = ((SuperMachine)TMG.currentState).linkBack;
        } else if (currentState instanceof Machine) {
            if (MyCanvas.debug) {
                System.out.println("in Machine");
            }
            currentState = ((TMG)((Machine)currentState).getChild()).getStartState();
        }
        if (MyCanvas.debug && currentState == null) {
            System.out.println("null------------State");
        }
        currentMachine = (TMG)currentState.getOwner();
        Ins ins2 = null;
        int n4 = -1;
        if (MyCanvas.debug) {
            System.out.println("for(int i=" + TMG.currentState.start + ";i<=" + TMG.currentState.end + ";i++)");
        }
        if (MyCanvas.debug) {
            System.out.println("currentState = " + currentState.getClass());
        }
        int n5 = TMG.currentState.start;
        while (n5 <= TMG.currentState.end) {
            n3 = 0;
            n2 = Tape.getNumTapes();
            ins = (Ins)currentMachine.getComp(n5);
            n = 0;
            while (n < n2) {
                if (MyCanvas.debug) {
                    System.out.println("comparing " + ins.getRead(n) + " and " + currentTape[n]);
                }
                if (ins.getRead(n) == currentTape[n]) {
                    ++n3;
                }
                ++n;
            }
            if (n3 == n2) {
                return ins;
            }
            ++n5;
        }
        if (wildcardsOn) {
            n3 = TMG.currentState.start;
            while (n3 <= TMG.currentState.end) {
                int n6;
                n2 = 0;
                n = Tape.getNumTapes();
                ins = (Ins)currentMachine.getComp(n3);
                int n7 = 0;
                while (n7 < n) {
                    if (ins.getRead(n7) == currentTape[n7] || ins.getRead(n7) == Alphabet.wildcard) {
                        ++n2;
                    }
                    ++n7;
                }
                if (n2 == n && (n6 = ins.getWildcardWeight()) > n4) {
                    n4 = n6;
                    ins2 = ins;
                }
                ++n3;
            }
        }
        return ins2;
    }

    public State find(String string) {
        return (State)this.find("tm2.State", string);
    }

    public boolean changeIns(Ins ins, char[] cArray) {
        this.editedSinceSave = true;
        if (type == 1) {
            return true;
        }
        int n = this.firstInstanceOf("tm2.Ins");
        int n2 = this.lastInstanceOf("tm2.Ins");
        int n3 = n;
        while (n3 <= n2) {
            if (this.getComp(n3) != ins && this.getComp(n3).getLink(0) == ins.getLink(0) && ((Ins)this.getComp(n3)).matchReads(cArray)) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.editedSinceSave = true;
        if (this.closedPopup) {
            this.closedPopup = false;
            return;
        }
        if (this.editMode == 0) {
            this.pick = this.locateMC(mouseEvent.getX(), mouseEvent.getY());
            if (this.pick != null) {
                this.pick.createPopupMenu(this);
                return;
            }
            new TMGPUM(this, mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        if (this.editMode == 1) {
            Ins ins = new Ins((State)this.pick, "?????", "?????", "RRRRR", (State)this.pick, mouseEvent.getX(), mouseEvent.getY());
            this.pick = ins;
            this.addMC(ins);
            if (autoAppendText) {
                TMGFTA tMGFTA = new TMGFTA(0, 0, ins, this.getGraphics());
                tMGFTA.retract(0);
                this.addMC(tMGFTA);
            }
            this.fullRepaint();
            this.editMode = 2;
            return;
        }
        if (this.editMode == 2) {
            MyComponent myComponent = this.locateMC(mouseEvent.getX(), mouseEvent.getY());
            if (myComponent instanceof State) {
                ((Ins)this.pick).linkTo((State)myComponent);
                if (autoEditIns) {
                    ((Ins)this.pick).createDialog(this);
                }
                this.fullRepaint();
                this.editMode = 0;
                return;
            }
        } else {
            if (this.editMode == 3) {
                MyComponent myComponent = this.locateMC(mouseEvent.getX(), mouseEvent.getY());
                if (myComponent instanceof State || myComponent instanceof Ins) {
                    ((TMGFTA)this.pick).linkTo(myComponent);
                    this.fullRepaint();
                    this.editMode = 0;
                }
                return;
            }
            if (this.editMode == 5) {
                this.paste(mouseEvent.getX(), mouseEvent.getY());
                this.editMode = 0;
                this.fullRepaint();
            }
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.editedSinceSave = true;
        if (itemEvent.getStateChange() == 1) {
            this.start();
            return;
        }
        isRunning = false;
        if (playButton.getState() == 1) {
            playButton.setState(2);
        }
    }

    public void itemEdited(EditEvent editEvent) {
        this.editedSinceSave = true;
        if (editEvent.getType() == 0) {
            this.fullRepaint();
            return;
        }
        if (editEvent.getType() == 2) {
            this.remove((MyComponent)editEvent.getItem());
            return;
        }
        if (editEvent.getType() == 1) {
            this.editMode = 3;
        }
    }

    public void windowClosing(WindowEvent windowEvent) {
        if (this == topLevelGraph) {
            if (this.editedSinceSave) {
                String string = this.askToSave();
                if (string.equals("Cancel")) {
                    return;
                }
                if (string.equals("Yes")) {
                    this.save();
                    System.exit(0);
                }
                if (string.equals("No")) {
                    System.exit(0);
                }
            }
            System.exit(0);
            return;
        }
        ((Component)this.myFrame).setVisible(false);
    }

    static {
        autoRetractText = true;
        autoReduceStates = true;
        tape = new Tape();
        lastIns = null;
        tt = null;
        playButton = new PB();
        type = 3;
        counter = new BigCounter(0, 10);
        currentFilename = null;
        currentTape = new char[5];
        mainFont = new Font("Monospaced", 0, 14);
        instructionFont = new Font("Monospaced", 0, 14);
    }
}

