/** Adam Badawy's homemade heap implementation. */
#ifndef HEAPANB_H_
#define HEAPANB_H_

#include <iostream>
#include <sstream>
#include <string>
#include <vector>

using std::cout;
using std::endl;
using std::string;
using std::stringstream;
using std::vector;

template <typename T> // REQ: operator<
class Heap // INV: The item at the top of the Heap is always >= all lower items.
{          // INV: Any popped item will be >= all other items in the Heap.
public:
    vector<T> data;

    Heap()
    {
        data = vector<T>();
    }

    size_t size() const // REQ: No items are stored in data if not "on the Heap"
    {
        return data.size();
    }

    void push(const T& item) // REQ: T has operator<
    {                        // ENS: All items in Heap are > their "children".
        int index = size();
        data.push_back(item);

        int parentIndex = (index - 1) / 2;
        T temp;
        while (parentIndex >= 0) // LOOP INV: index is always the index of the
        {                        //           pushed item.
            if (data[parentIndex] < item)
            {
                temp = data[parentIndex];
                data[parentIndex] = data[index];
                data[index] = temp;

                index = parentIndex;
                parentIndex = (index - 1) / 2;
            }
            else
            {
                parentIndex = -1;
            }

        }
    }

    T pop() // REQ: T has operator<
    {       // ENS: All items in Heap are > their "children".
        T temp = data[0];
        data[0] = data[size() - 1];
        data.pop_back();

        for (size_t i = 0; i < size(); i++) // LOOP INV: indexes >= size() are
        {                                   //           never checked.
            if ((i * 2) + 1 < size())
            {
                if (data[i] < data[(i * 2) + 1])
                {
                    fixDown(i);
                }
            }

            if ((i * 2) + 2 < size())
            {
                if (data[i] < data[(i * 2) + 2])
                {
                    fixDown(i);
                }
            }
        }

        return temp;
    }

    void fixDown(size_t index) // REQ: T has operator<
    {
        T temp;

        size_t child = (index * 2) + 1;
        while (child < size()) // LOOP INV: indexes >= size() are never checked.
        {
            if (data[index] < data[child])
            {
                temp = data[index];
                data[index] = data[child];
                data[child] = temp;

                index = child;
                child = (index * 2) + 1;
            }
            else if (child + 1 < size())
            {
                if (data[index] < data[child + 1])
                {
                    temp = data[index];
                    data[index] = data[child + 1];
                    data[child + 1] = temp;

                    index = child + 1;
                    child = (index * 2) + 1;
                }
                else
                {
                    child = size();
                }
            }
            else
            {
                child = size();
            }
        }
    }

    string toString() const // REQ: T has operator<<
    {
        stringstream ss;
        for (size_t i = 0; i < size(); i++)
        {
            ss << data[i] << endl;
        }
        return ss.str();
    }
};

#endif

