#include <iostream>
#include <vector>
#include <string>
#include <sstream>

using std::iostream;
using std::vector;
using std::string;
using std::stringstream;

template <class T>
class StackPairANB {

    vector<T>* elements;
    int frontItem;
    int rearSpace;
    int upperBound;

public:

    StackPairANB(int guaranteedCapacity)
    {
        elements = new vector<T>(2 * guaranteedCapacity);
        frontItem = guaranteedCapacity;
        rearSpace = guaranteedCapacity;
        upperBound = 2 * guaranteedCapacity;
    }

    ~StackPairANB() {}

    virtual bool isEmpty() const {
        return frontItem == rearSpace;
    }

    virtual bool isFull() const {
        return (frontItem == 0 && rearSpace == upperBound);
    }

    virtual int size() const {
        return rearSpace - frontItem;
    }

    virtual T popRear()
    {
        try {
            if (isEmpty()) {
                throw 20;
            } else {
                return elements->at(--rearSpace);
            }
        } catch (int e) {
            cerr << "Cannot call popRear() on an empty StackPair object." << endl;
        }
    }

    virtual T popFront()
    {
        try {
            if (isEmpty()) {
                throw 20;
            } else {
                return elements->at(frontItem++);
            }
        } catch (int e) {
            cerr << "Cannot call popFront() on an empty StackPair object." << endl;
        }
    }

    virtual void pushFront(T newItem)
    {
        try {
            if (frontItem == 0) {
                throw 20;
            } else {
                elements->at(rearSpace++) = newItem;
            }
        } catch (int e) {
            cerr << "Rear stack is full; cannot call pushRear()." << endl;
        }
    }

    virtual void pushRear(T newItem)
    {
        try {
            if (rearSpace == upperBound) {
                throw 20;
            } else {
                elements->at(--frontItem) = newItem;
            }
        } catch (int e) {
            cerr << "Front stack is full; cannot call pushFront()." << endl;
        }
    }

    virtual string toString()
    {
        stringstream out;
        for (int i = frontItem; i < rearSpace; i++) {
            out << elements->at(i) << " ";
        }
        return out.str();
    }
};

